/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.FlowFilter;
import software.amazon.awssdk.services.networkfirewall.model.FlowFiltersCopier;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartFlowCaptureRequest
extends NetworkFirewallRequest
implements ToCopyableBuilder<Builder, StartFlowCaptureRequest> {
    private static final SdkField<String> FIREWALL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallArn").getter(StartFlowCaptureRequest.getter(StartFlowCaptureRequest::firewallArn)).setter(StartFlowCaptureRequest.setter(Builder::firewallArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallArn").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(StartFlowCaptureRequest.getter(StartFlowCaptureRequest::availabilityZone)).setter(StartFlowCaptureRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<Integer> MINIMUM_FLOW_AGE_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinimumFlowAgeInSeconds").getter(StartFlowCaptureRequest.getter(StartFlowCaptureRequest::minimumFlowAgeInSeconds)).setter(StartFlowCaptureRequest.setter(Builder::minimumFlowAgeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumFlowAgeInSeconds").build()}).build();
    private static final SdkField<List<FlowFilter>> FLOW_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FlowFilters").getter(StartFlowCaptureRequest.getter(StartFlowCaptureRequest::flowFilters)).setter(StartFlowCaptureRequest.setter(Builder::flowFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FlowFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_ARN_FIELD, AVAILABILITY_ZONE_FIELD, MINIMUM_FLOW_AGE_IN_SECONDS_FIELD, FLOW_FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartFlowCaptureRequest.memberNameToFieldInitializer();
    private final String firewallArn;
    private final String availabilityZone;
    private final Integer minimumFlowAgeInSeconds;
    private final List<FlowFilter> flowFilters;

    private StartFlowCaptureRequest(BuilderImpl builder) {
        super(builder);
        this.firewallArn = builder.firewallArn;
        this.availabilityZone = builder.availabilityZone;
        this.minimumFlowAgeInSeconds = builder.minimumFlowAgeInSeconds;
        this.flowFilters = builder.flowFilters;
    }

    public final String firewallArn() {
        return this.firewallArn;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final Integer minimumFlowAgeInSeconds() {
        return this.minimumFlowAgeInSeconds;
    }

    public final boolean hasFlowFilters() {
        return this.flowFilters != null && !(this.flowFilters instanceof SdkAutoConstructList);
    }

    public final List<FlowFilter> flowFilters() {
        return this.flowFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumFlowAgeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFlowFilters() ? this.flowFilters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartFlowCaptureRequest)) {
            return false;
        }
        StartFlowCaptureRequest other = (StartFlowCaptureRequest)((Object)obj);
        return Objects.equals(this.firewallArn(), other.firewallArn()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.minimumFlowAgeInSeconds(), other.minimumFlowAgeInSeconds()) && this.hasFlowFilters() == other.hasFlowFilters() && Objects.equals(this.flowFilters(), other.flowFilters());
    }

    public final String toString() {
        return ToString.builder((String)"StartFlowCaptureRequest").add("FirewallArn", (Object)this.firewallArn()).add("AvailabilityZone", (Object)this.availabilityZone()).add("MinimumFlowAgeInSeconds", (Object)this.minimumFlowAgeInSeconds()).add("FlowFilters", this.hasFlowFilters() ? this.flowFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FirewallArn": {
                return Optional.ofNullable(clazz.cast(this.firewallArn()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "MinimumFlowAgeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.minimumFlowAgeInSeconds()));
            }
            case "FlowFilters": {
                return Optional.ofNullable(clazz.cast(this.flowFilters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FirewallArn", FIREWALL_ARN_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("MinimumFlowAgeInSeconds", MINIMUM_FLOW_AGE_IN_SECONDS_FIELD);
        map.put("FlowFilters", FLOW_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartFlowCaptureRequest, T> g) {
        return obj -> g.apply((StartFlowCaptureRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallRequest.BuilderImpl
    implements Builder {
        private String firewallArn;
        private String availabilityZone;
        private Integer minimumFlowAgeInSeconds;
        private List<FlowFilter> flowFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartFlowCaptureRequest model) {
            super(model);
            this.firewallArn(model.firewallArn);
            this.availabilityZone(model.availabilityZone);
            this.minimumFlowAgeInSeconds(model.minimumFlowAgeInSeconds);
            this.flowFilters(model.flowFilters);
        }

        public final String getFirewallArn() {
            return this.firewallArn;
        }

        public final void setFirewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
        }

        @Override
        public final Builder firewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Integer getMinimumFlowAgeInSeconds() {
            return this.minimumFlowAgeInSeconds;
        }

        public final void setMinimumFlowAgeInSeconds(Integer minimumFlowAgeInSeconds) {
            this.minimumFlowAgeInSeconds = minimumFlowAgeInSeconds;
        }

        @Override
        public final Builder minimumFlowAgeInSeconds(Integer minimumFlowAgeInSeconds) {
            this.minimumFlowAgeInSeconds = minimumFlowAgeInSeconds;
            return this;
        }

        public final List<FlowFilter.Builder> getFlowFilters() {
            List<FlowFilter.Builder> result = FlowFiltersCopier.copyToBuilder(this.flowFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFlowFilters(Collection<FlowFilter.BuilderImpl> flowFilters) {
            this.flowFilters = FlowFiltersCopier.copyFromBuilder(flowFilters);
        }

        @Override
        public final Builder flowFilters(Collection<FlowFilter> flowFilters) {
            this.flowFilters = FlowFiltersCopier.copy(flowFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowFilters(FlowFilter ... flowFilters) {
            this.flowFilters(Arrays.asList(flowFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowFilters(Consumer<FlowFilter.Builder> ... flowFilters) {
            this.flowFilters(Stream.of(flowFilters).map(c -> (FlowFilter)((FlowFilter.Builder)FlowFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartFlowCaptureRequest build() {
            return new StartFlowCaptureRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NetworkFirewallRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartFlowCaptureRequest> {
        public Builder firewallArn(String var1);

        public Builder availabilityZone(String var1);

        public Builder minimumFlowAgeInSeconds(Integer var1);

        public Builder flowFilters(Collection<FlowFilter> var1);

        public Builder flowFilters(FlowFilter ... var1);

        public Builder flowFilters(Consumer<FlowFilter.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

