/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StatefulAction {
    PASS("PASS"),
    DROP("DROP"),
    ALERT("ALERT"),
    REJECT("REJECT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StatefulAction> VALUE_MAP;
    private final String value;

    private StatefulAction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StatefulAction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StatefulAction> knownValues() {
        EnumSet<StatefulAction> knownValues = EnumSet.allOf(StatefulAction.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StatefulAction.class, StatefulAction::toString);
    }
}

