/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkfirewall.model.CreateProxyRulesByRequestPhase;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProxyRulesRequest
extends NetworkFirewallRequest
implements ToCopyableBuilder<Builder, CreateProxyRulesRequest> {
    private static final SdkField<String> PROXY_RULE_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyRuleGroupArn").getter(CreateProxyRulesRequest.getter(CreateProxyRulesRequest::proxyRuleGroupArn)).setter(CreateProxyRulesRequest.setter(Builder::proxyRuleGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyRuleGroupArn").build()}).build();
    private static final SdkField<String> PROXY_RULE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyRuleGroupName").getter(CreateProxyRulesRequest.getter(CreateProxyRulesRequest::proxyRuleGroupName)).setter(CreateProxyRulesRequest.setter(Builder::proxyRuleGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyRuleGroupName").build()}).build();
    private static final SdkField<CreateProxyRulesByRequestPhase> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Rules").getter(CreateProxyRulesRequest.getter(CreateProxyRulesRequest::rules)).setter(CreateProxyRulesRequest.setter(Builder::rules)).constructor(CreateProxyRulesByRequestPhase::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXY_RULE_GROUP_ARN_FIELD, PROXY_RULE_GROUP_NAME_FIELD, RULES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateProxyRulesRequest.memberNameToFieldInitializer();
    private final String proxyRuleGroupArn;
    private final String proxyRuleGroupName;
    private final CreateProxyRulesByRequestPhase rules;

    private CreateProxyRulesRequest(BuilderImpl builder) {
        super(builder);
        this.proxyRuleGroupArn = builder.proxyRuleGroupArn;
        this.proxyRuleGroupName = builder.proxyRuleGroupName;
        this.rules = builder.rules;
    }

    public final String proxyRuleGroupArn() {
        return this.proxyRuleGroupArn;
    }

    public final String proxyRuleGroupName() {
        return this.proxyRuleGroupName;
    }

    public final CreateProxyRulesByRequestPhase rules() {
        return this.rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyRuleGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyRuleGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.rules());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProxyRulesRequest)) {
            return false;
        }
        CreateProxyRulesRequest other = (CreateProxyRulesRequest)((Object)obj);
        return Objects.equals(this.proxyRuleGroupArn(), other.proxyRuleGroupArn()) && Objects.equals(this.proxyRuleGroupName(), other.proxyRuleGroupName()) && Objects.equals(this.rules(), other.rules());
    }

    public final String toString() {
        return ToString.builder((String)"CreateProxyRulesRequest").add("ProxyRuleGroupArn", (Object)this.proxyRuleGroupArn()).add("ProxyRuleGroupName", (Object)this.proxyRuleGroupName()).add("Rules", (Object)this.rules()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProxyRuleGroupArn": {
                return Optional.ofNullable(clazz.cast(this.proxyRuleGroupArn()));
            }
            case "ProxyRuleGroupName": {
                return Optional.ofNullable(clazz.cast(this.proxyRuleGroupName()));
            }
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProxyRuleGroupArn", PROXY_RULE_GROUP_ARN_FIELD);
        map.put("ProxyRuleGroupName", PROXY_RULE_GROUP_NAME_FIELD);
        map.put("Rules", RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProxyRulesRequest, T> g) {
        return obj -> g.apply((CreateProxyRulesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallRequest.BuilderImpl
    implements Builder {
        private String proxyRuleGroupArn;
        private String proxyRuleGroupName;
        private CreateProxyRulesByRequestPhase rules;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProxyRulesRequest model) {
            super(model);
            this.proxyRuleGroupArn(model.proxyRuleGroupArn);
            this.proxyRuleGroupName(model.proxyRuleGroupName);
            this.rules(model.rules);
        }

        public final String getProxyRuleGroupArn() {
            return this.proxyRuleGroupArn;
        }

        public final void setProxyRuleGroupArn(String proxyRuleGroupArn) {
            this.proxyRuleGroupArn = proxyRuleGroupArn;
        }

        @Override
        public final Builder proxyRuleGroupArn(String proxyRuleGroupArn) {
            this.proxyRuleGroupArn = proxyRuleGroupArn;
            return this;
        }

        public final String getProxyRuleGroupName() {
            return this.proxyRuleGroupName;
        }

        public final void setProxyRuleGroupName(String proxyRuleGroupName) {
            this.proxyRuleGroupName = proxyRuleGroupName;
        }

        @Override
        public final Builder proxyRuleGroupName(String proxyRuleGroupName) {
            this.proxyRuleGroupName = proxyRuleGroupName;
            return this;
        }

        public final CreateProxyRulesByRequestPhase.Builder getRules() {
            return this.rules != null ? this.rules.toBuilder() : null;
        }

        public final void setRules(CreateProxyRulesByRequestPhase.BuilderImpl rules) {
            this.rules = rules != null ? rules.build() : null;
        }

        @Override
        public final Builder rules(CreateProxyRulesByRequestPhase rules) {
            this.rules = rules;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProxyRulesRequest build() {
            return new CreateProxyRulesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkFirewallRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProxyRulesRequest> {
        public Builder proxyRuleGroupArn(String var1);

        public Builder proxyRuleGroupName(String var1);

        public Builder rules(CreateProxyRulesByRequestPhase var1);

        default public Builder rules(Consumer<CreateProxyRulesByRequestPhase.Builder> rules) {
            return this.rules((CreateProxyRulesByRequestPhase)((CreateProxyRulesByRequestPhase.Builder)CreateProxyRulesByRequestPhase.builder().applyMutation(rules)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

