/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallResponse;
import software.amazon.awssdk.services.networkfirewall.model.ProxyRuleGroupMetadata;
import software.amazon.awssdk.services.networkfirewall.model.ProxyRuleGroupsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProxyRuleGroupsResponse
extends NetworkFirewallResponse
implements ToCopyableBuilder<Builder, ListProxyRuleGroupsResponse> {
    private static final SdkField<List<ProxyRuleGroupMetadata>> PROXY_RULE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProxyRuleGroups").getter(ListProxyRuleGroupsResponse.getter(ListProxyRuleGroupsResponse::proxyRuleGroups)).setter(ListProxyRuleGroupsResponse.setter(Builder::proxyRuleGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyRuleGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProxyRuleGroupMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListProxyRuleGroupsResponse.getter(ListProxyRuleGroupsResponse::nextToken)).setter(ListProxyRuleGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXY_RULE_GROUPS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListProxyRuleGroupsResponse.memberNameToFieldInitializer();
    private final List<ProxyRuleGroupMetadata> proxyRuleGroups;
    private final String nextToken;

    private ListProxyRuleGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.proxyRuleGroups = builder.proxyRuleGroups;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasProxyRuleGroups() {
        return this.proxyRuleGroups != null && !(this.proxyRuleGroups instanceof SdkAutoConstructList);
    }

    public final List<ProxyRuleGroupMetadata> proxyRuleGroups() {
        return this.proxyRuleGroups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProxyRuleGroups() ? this.proxyRuleGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProxyRuleGroupsResponse)) {
            return false;
        }
        ListProxyRuleGroupsResponse other = (ListProxyRuleGroupsResponse)((Object)obj);
        return this.hasProxyRuleGroups() == other.hasProxyRuleGroups() && Objects.equals(this.proxyRuleGroups(), other.proxyRuleGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListProxyRuleGroupsResponse").add("ProxyRuleGroups", this.hasProxyRuleGroups() ? this.proxyRuleGroups() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProxyRuleGroups": {
                return Optional.ofNullable(clazz.cast(this.proxyRuleGroups()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProxyRuleGroups", PROXY_RULE_GROUPS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListProxyRuleGroupsResponse, T> g) {
        return obj -> g.apply((ListProxyRuleGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallResponse.BuilderImpl
    implements Builder {
        private List<ProxyRuleGroupMetadata> proxyRuleGroups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProxyRuleGroupsResponse model) {
            super(model);
            this.proxyRuleGroups(model.proxyRuleGroups);
            this.nextToken(model.nextToken);
        }

        public final List<ProxyRuleGroupMetadata.Builder> getProxyRuleGroups() {
            List<ProxyRuleGroupMetadata.Builder> result = ProxyRuleGroupsCopier.copyToBuilder(this.proxyRuleGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProxyRuleGroups(Collection<ProxyRuleGroupMetadata.BuilderImpl> proxyRuleGroups) {
            this.proxyRuleGroups = ProxyRuleGroupsCopier.copyFromBuilder(proxyRuleGroups);
        }

        @Override
        public final Builder proxyRuleGroups(Collection<ProxyRuleGroupMetadata> proxyRuleGroups) {
            this.proxyRuleGroups = ProxyRuleGroupsCopier.copy(proxyRuleGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proxyRuleGroups(ProxyRuleGroupMetadata ... proxyRuleGroups) {
            this.proxyRuleGroups(Arrays.asList(proxyRuleGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proxyRuleGroups(Consumer<ProxyRuleGroupMetadata.Builder> ... proxyRuleGroups) {
            this.proxyRuleGroups(Stream.of(proxyRuleGroups).map(c -> (ProxyRuleGroupMetadata)((ProxyRuleGroupMetadata.Builder)ProxyRuleGroupMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListProxyRuleGroupsResponse build() {
            return new ListProxyRuleGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkFirewallResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProxyRuleGroupsResponse> {
        public Builder proxyRuleGroups(Collection<ProxyRuleGroupMetadata> var1);

        public Builder proxyRuleGroups(ProxyRuleGroupMetadata ... var1);

        public Builder proxyRuleGroups(Consumer<ProxyRuleGroupMetadata.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

