/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallClient;
import software.amazon.awssdk.services.networkfirewall.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkfirewall.model.Flow;
import software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationResultsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationResultsResponse;

public class ListFlowOperationResultsIterable
implements SdkIterable<ListFlowOperationResultsResponse> {
    private final NetworkFirewallClient client;
    private final ListFlowOperationResultsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFlowOperationResultsIterable(NetworkFirewallClient client, ListFlowOperationResultsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFlowOperationResultsResponseFetcher();
    }

    public Iterator<ListFlowOperationResultsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Flow> flows() {
        Function<ListFlowOperationResultsResponse, Iterator> getIterator = response -> {
            if (response != null && response.flows() != null) {
                return response.flows().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFlowOperationResultsResponseFetcher
    implements SyncPageFetcher<ListFlowOperationResultsResponse> {
        private ListFlowOperationResultsResponseFetcher() {
        }

        public boolean hasNextPage(ListFlowOperationResultsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFlowOperationResultsResponse nextPage(ListFlowOperationResultsResponse previousPage) {
            if (previousPage == null) {
                return ListFlowOperationResultsIterable.this.client.listFlowOperationResults(ListFlowOperationResultsIterable.this.firstRequest);
            }
            return ListFlowOperationResultsIterable.this.client.listFlowOperationResults((ListFlowOperationResultsRequest)((Object)ListFlowOperationResultsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

