/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallAsyncClient;
import software.amazon.awssdk.services.networkfirewall.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkfirewall.model.ListProxiesRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListProxiesResponse;
import software.amazon.awssdk.services.networkfirewall.model.ProxyMetadata;

public class ListProxiesPublisher
implements SdkPublisher<ListProxiesResponse> {
    private final NetworkFirewallAsyncClient client;
    private final ListProxiesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProxiesPublisher(NetworkFirewallAsyncClient client, ListProxiesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProxiesPublisher(NetworkFirewallAsyncClient client, ListProxiesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProxiesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProxiesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProxyMetadata> proxies() {
        Function<ListProxiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.proxies() != null) {
                return response.proxies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListProxiesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListProxiesResponseFetcher
    implements AsyncPageFetcher<ListProxiesResponse> {
        private ListProxiesResponseFetcher() {
        }

        public boolean hasNextPage(ListProxiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProxiesResponse> nextPage(ListProxiesResponse previousPage) {
            if (previousPage == null) {
                return ListProxiesPublisher.this.client.listProxies(ListProxiesPublisher.this.firstRequest);
            }
            return ListProxiesPublisher.this.client.listProxies((ListProxiesRequest)((Object)ListProxiesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

