/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallClient;
import software.amazon.awssdk.services.networkfirewall.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkfirewall.model.ListProxyConfigurationsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListProxyConfigurationsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ProxyConfigurationMetadata;

public class ListProxyConfigurationsIterable
implements SdkIterable<ListProxyConfigurationsResponse> {
    private final NetworkFirewallClient client;
    private final ListProxyConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProxyConfigurationsIterable(NetworkFirewallClient client, ListProxyConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListProxyConfigurationsResponseFetcher();
    }

    public Iterator<ListProxyConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProxyConfigurationMetadata> proxyConfigurations() {
        Function<ListProxyConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.proxyConfigurations() != null) {
                return response.proxyConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListProxyConfigurationsResponseFetcher
    implements SyncPageFetcher<ListProxyConfigurationsResponse> {
        private ListProxyConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListProxyConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProxyConfigurationsResponse nextPage(ListProxyConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListProxyConfigurationsIterable.this.client.listProxyConfigurations(ListProxyConfigurationsIterable.this.firstRequest);
            }
            return ListProxyConfigurationsIterable.this.client.listProxyConfigurations((ListProxyConfigurationsRequest)((Object)ListProxyConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

