/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.ProxyRuleCondition;
import software.amazon.awssdk.services.networkfirewall.model.ProxyRuleConditionListCopier;
import software.amazon.awssdk.services.networkfirewall.model.ProxyRulePhaseAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProxyRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateProxyRule> {
    private static final SdkField<String> PROXY_RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyRuleName").getter(CreateProxyRule.getter(CreateProxyRule::proxyRuleName)).setter(CreateProxyRule.setter(Builder::proxyRuleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyRuleName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateProxyRule.getter(CreateProxyRule::description)).setter(CreateProxyRule.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(CreateProxyRule.getter(CreateProxyRule::actionAsString)).setter(CreateProxyRule.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<List<ProxyRuleCondition>> CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Conditions").getter(CreateProxyRule.getter(CreateProxyRule::conditions)).setter(CreateProxyRule.setter(Builder::conditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Conditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProxyRuleCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> INSERT_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InsertPosition").getter(CreateProxyRule.getter(CreateProxyRule::insertPosition)).setter(CreateProxyRule.setter(Builder::insertPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsertPosition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXY_RULE_NAME_FIELD, DESCRIPTION_FIELD, ACTION_FIELD, CONDITIONS_FIELD, INSERT_POSITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateProxyRule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String proxyRuleName;
    private final String description;
    private final String action;
    private final List<ProxyRuleCondition> conditions;
    private final Integer insertPosition;

    private CreateProxyRule(BuilderImpl builder) {
        this.proxyRuleName = builder.proxyRuleName;
        this.description = builder.description;
        this.action = builder.action;
        this.conditions = builder.conditions;
        this.insertPosition = builder.insertPosition;
    }

    public final String proxyRuleName() {
        return this.proxyRuleName;
    }

    public final String description() {
        return this.description;
    }

    public final ProxyRulePhaseAction action() {
        return ProxyRulePhaseAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final boolean hasConditions() {
        return this.conditions != null && !(this.conditions instanceof SdkAutoConstructList);
    }

    public final List<ProxyRuleCondition> conditions() {
        return this.conditions;
    }

    public final Integer insertPosition() {
        return this.insertPosition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConditions() ? this.conditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.insertPosition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProxyRule)) {
            return false;
        }
        CreateProxyRule other = (CreateProxyRule)obj;
        return Objects.equals(this.proxyRuleName(), other.proxyRuleName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.actionAsString(), other.actionAsString()) && this.hasConditions() == other.hasConditions() && Objects.equals(this.conditions(), other.conditions()) && Objects.equals(this.insertPosition(), other.insertPosition());
    }

    public final String toString() {
        return ToString.builder((String)"CreateProxyRule").add("ProxyRuleName", (Object)this.proxyRuleName()).add("Description", (Object)this.description()).add("Action", (Object)this.actionAsString()).add("Conditions", this.hasConditions() ? this.conditions() : null).add("InsertPosition", (Object)this.insertPosition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProxyRuleName": {
                return Optional.ofNullable(clazz.cast(this.proxyRuleName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "Conditions": {
                return Optional.ofNullable(clazz.cast(this.conditions()));
            }
            case "InsertPosition": {
                return Optional.ofNullable(clazz.cast(this.insertPosition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProxyRuleName", PROXY_RULE_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Action", ACTION_FIELD);
        map.put("Conditions", CONDITIONS_FIELD);
        map.put("InsertPosition", INSERT_POSITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProxyRule, T> g) {
        return obj -> g.apply((CreateProxyRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String proxyRuleName;
        private String description;
        private String action;
        private List<ProxyRuleCondition> conditions = DefaultSdkAutoConstructList.getInstance();
        private Integer insertPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProxyRule model) {
            this.proxyRuleName(model.proxyRuleName);
            this.description(model.description);
            this.action(model.action);
            this.conditions(model.conditions);
            this.insertPosition(model.insertPosition);
        }

        public final String getProxyRuleName() {
            return this.proxyRuleName;
        }

        public final void setProxyRuleName(String proxyRuleName) {
            this.proxyRuleName = proxyRuleName;
        }

        @Override
        public final Builder proxyRuleName(String proxyRuleName) {
            this.proxyRuleName = proxyRuleName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ProxyRulePhaseAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final List<ProxyRuleCondition.Builder> getConditions() {
            List<ProxyRuleCondition.Builder> result = ProxyRuleConditionListCopier.copyToBuilder(this.conditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConditions(Collection<ProxyRuleCondition.BuilderImpl> conditions) {
            this.conditions = ProxyRuleConditionListCopier.copyFromBuilder(conditions);
        }

        @Override
        public final Builder conditions(Collection<ProxyRuleCondition> conditions) {
            this.conditions = ProxyRuleConditionListCopier.copy(conditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(ProxyRuleCondition ... conditions) {
            this.conditions(Arrays.asList(conditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Consumer<ProxyRuleCondition.Builder> ... conditions) {
            this.conditions(Stream.of(conditions).map(c -> (ProxyRuleCondition)((ProxyRuleCondition.Builder)ProxyRuleCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getInsertPosition() {
            return this.insertPosition;
        }

        public final void setInsertPosition(Integer insertPosition) {
            this.insertPosition = insertPosition;
        }

        @Override
        public final Builder insertPosition(Integer insertPosition) {
            this.insertPosition = insertPosition;
            return this;
        }

        public CreateProxyRule build() {
            return new CreateProxyRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateProxyRule> {
        public Builder proxyRuleName(String var1);

        public Builder description(String var1);

        public Builder action(String var1);

        public Builder action(ProxyRulePhaseAction var1);

        public Builder conditions(Collection<ProxyRuleCondition> var1);

        public Builder conditions(ProxyRuleCondition ... var1);

        public Builder conditions(Consumer<ProxyRuleCondition.Builder> ... var1);

        public Builder insertPosition(Integer var1);
    }
}

