/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFirewallMetadataRequest
extends NetworkFirewallRequest
implements ToCopyableBuilder<Builder, DescribeFirewallMetadataRequest> {
    private static final SdkField<String> FIREWALL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallArn").getter(DescribeFirewallMetadataRequest.getter(DescribeFirewallMetadataRequest::firewallArn)).setter(DescribeFirewallMetadataRequest.setter(Builder::firewallArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeFirewallMetadataRequest.memberNameToFieldInitializer();
    private final String firewallArn;

    private DescribeFirewallMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.firewallArn = builder.firewallArn;
    }

    public final String firewallArn() {
        return this.firewallArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFirewallMetadataRequest)) {
            return false;
        }
        DescribeFirewallMetadataRequest other = (DescribeFirewallMetadataRequest)((Object)obj);
        return Objects.equals(this.firewallArn(), other.firewallArn());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFirewallMetadataRequest").add("FirewallArn", (Object)this.firewallArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FirewallArn": {
                return Optional.ofNullable(clazz.cast(this.firewallArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("FirewallArn", FIREWALL_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFirewallMetadataRequest, T> g) {
        return obj -> g.apply((DescribeFirewallMetadataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallRequest.BuilderImpl
    implements Builder {
        private String firewallArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFirewallMetadataRequest model) {
            super(model);
            this.firewallArn(model.firewallArn);
        }

        public final String getFirewallArn() {
            return this.firewallArn;
        }

        public final void setFirewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
        }

        @Override
        public final Builder firewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeFirewallMetadataRequest build() {
            return new DescribeFirewallMetadataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkFirewallRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFirewallMetadataRequest> {
        public Builder firewallArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

