/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkfirewall.model.FlowOperation;
import software.amazon.awssdk.services.networkfirewall.model.FlowOperationStatus;
import software.amazon.awssdk.services.networkfirewall.model.FlowOperationType;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFlowOperationResponse
extends NetworkFirewallResponse
implements ToCopyableBuilder<Builder, DescribeFlowOperationResponse> {
    private static final SdkField<String> FIREWALL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallArn").getter(DescribeFlowOperationResponse.getter(DescribeFlowOperationResponse::firewallArn)).setter(DescribeFlowOperationResponse.setter(Builder::firewallArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallArn").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(DescribeFlowOperationResponse.getter(DescribeFlowOperationResponse::availabilityZone)).setter(DescribeFlowOperationResponse.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_ASSOCIATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcEndpointAssociationArn").getter(DescribeFlowOperationResponse.getter(DescribeFlowOperationResponse::vpcEndpointAssociationArn)).setter(DescribeFlowOperationResponse.setter(Builder::vpcEndpointAssociationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointAssociationArn").build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcEndpointId").getter(DescribeFlowOperationResponse.getter(DescribeFlowOperationResponse::vpcEndpointId)).setter(DescribeFlowOperationResponse.setter(Builder::vpcEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId").build()}).build();
    private static final SdkField<String> FLOW_OPERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowOperationId").getter(DescribeFlowOperationResponse.getter(DescribeFlowOperationResponse::flowOperationId)).setter(DescribeFlowOperationResponse.setter(Builder::flowOperationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowOperationId").build()}).build();
    private static final SdkField<String> FLOW_OPERATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowOperationType").getter(DescribeFlowOperationResponse.getter(DescribeFlowOperationResponse::flowOperationTypeAsString)).setter(DescribeFlowOperationResponse.setter(Builder::flowOperationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowOperationType").build()}).build();
    private static final SdkField<String> FLOW_OPERATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowOperationStatus").getter(DescribeFlowOperationResponse.getter(DescribeFlowOperationResponse::flowOperationStatusAsString)).setter(DescribeFlowOperationResponse.setter(Builder::flowOperationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowOperationStatus").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(DescribeFlowOperationResponse.getter(DescribeFlowOperationResponse::statusMessage)).setter(DescribeFlowOperationResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<Instant> FLOW_REQUEST_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("FlowRequestTimestamp").getter(DescribeFlowOperationResponse.getter(DescribeFlowOperationResponse::flowRequestTimestamp)).setter(DescribeFlowOperationResponse.setter(Builder::flowRequestTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowRequestTimestamp").build()}).build();
    private static final SdkField<FlowOperation> FLOW_OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FlowOperation").getter(DescribeFlowOperationResponse.getter(DescribeFlowOperationResponse::flowOperation)).setter(DescribeFlowOperationResponse.setter(Builder::flowOperation)).constructor(FlowOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowOperation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_ARN_FIELD, AVAILABILITY_ZONE_FIELD, VPC_ENDPOINT_ASSOCIATION_ARN_FIELD, VPC_ENDPOINT_ID_FIELD, FLOW_OPERATION_ID_FIELD, FLOW_OPERATION_TYPE_FIELD, FLOW_OPERATION_STATUS_FIELD, STATUS_MESSAGE_FIELD, FLOW_REQUEST_TIMESTAMP_FIELD, FLOW_OPERATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeFlowOperationResponse.memberNameToFieldInitializer();
    private final String firewallArn;
    private final String availabilityZone;
    private final String vpcEndpointAssociationArn;
    private final String vpcEndpointId;
    private final String flowOperationId;
    private final String flowOperationType;
    private final String flowOperationStatus;
    private final String statusMessage;
    private final Instant flowRequestTimestamp;
    private final FlowOperation flowOperation;

    private DescribeFlowOperationResponse(BuilderImpl builder) {
        super(builder);
        this.firewallArn = builder.firewallArn;
        this.availabilityZone = builder.availabilityZone;
        this.vpcEndpointAssociationArn = builder.vpcEndpointAssociationArn;
        this.vpcEndpointId = builder.vpcEndpointId;
        this.flowOperationId = builder.flowOperationId;
        this.flowOperationType = builder.flowOperationType;
        this.flowOperationStatus = builder.flowOperationStatus;
        this.statusMessage = builder.statusMessage;
        this.flowRequestTimestamp = builder.flowRequestTimestamp;
        this.flowOperation = builder.flowOperation;
    }

    public final String firewallArn() {
        return this.firewallArn;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String vpcEndpointAssociationArn() {
        return this.vpcEndpointAssociationArn;
    }

    public final String vpcEndpointId() {
        return this.vpcEndpointId;
    }

    public final String flowOperationId() {
        return this.flowOperationId;
    }

    public final FlowOperationType flowOperationType() {
        return FlowOperationType.fromValue(this.flowOperationType);
    }

    public final String flowOperationTypeAsString() {
        return this.flowOperationType;
    }

    public final FlowOperationStatus flowOperationStatus() {
        return FlowOperationStatus.fromValue(this.flowOperationStatus);
    }

    public final String flowOperationStatusAsString() {
        return this.flowOperationStatus;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final Instant flowRequestTimestamp() {
        return this.flowRequestTimestamp;
    }

    public final FlowOperation flowOperation() {
        return this.flowOperation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowOperationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowOperationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowOperationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowRequestTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowOperation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFlowOperationResponse)) {
            return false;
        }
        DescribeFlowOperationResponse other = (DescribeFlowOperationResponse)((Object)obj);
        return Objects.equals(this.firewallArn(), other.firewallArn()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.vpcEndpointAssociationArn(), other.vpcEndpointAssociationArn()) && Objects.equals(this.vpcEndpointId(), other.vpcEndpointId()) && Objects.equals(this.flowOperationId(), other.flowOperationId()) && Objects.equals(this.flowOperationTypeAsString(), other.flowOperationTypeAsString()) && Objects.equals(this.flowOperationStatusAsString(), other.flowOperationStatusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.flowRequestTimestamp(), other.flowRequestTimestamp()) && Objects.equals(this.flowOperation(), other.flowOperation());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFlowOperationResponse").add("FirewallArn", (Object)this.firewallArn()).add("AvailabilityZone", (Object)this.availabilityZone()).add("VpcEndpointAssociationArn", (Object)this.vpcEndpointAssociationArn()).add("VpcEndpointId", (Object)this.vpcEndpointId()).add("FlowOperationId", (Object)this.flowOperationId()).add("FlowOperationType", (Object)this.flowOperationTypeAsString()).add("FlowOperationStatus", (Object)this.flowOperationStatusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("FlowRequestTimestamp", (Object)this.flowRequestTimestamp()).add("FlowOperation", (Object)this.flowOperation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FirewallArn": {
                return Optional.ofNullable(clazz.cast(this.firewallArn()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "VpcEndpointAssociationArn": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointAssociationArn()));
            }
            case "VpcEndpointId": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointId()));
            }
            case "FlowOperationId": {
                return Optional.ofNullable(clazz.cast(this.flowOperationId()));
            }
            case "FlowOperationType": {
                return Optional.ofNullable(clazz.cast(this.flowOperationTypeAsString()));
            }
            case "FlowOperationStatus": {
                return Optional.ofNullable(clazz.cast(this.flowOperationStatusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "FlowRequestTimestamp": {
                return Optional.ofNullable(clazz.cast(this.flowRequestTimestamp()));
            }
            case "FlowOperation": {
                return Optional.ofNullable(clazz.cast(this.flowOperation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FirewallArn", FIREWALL_ARN_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("VpcEndpointAssociationArn", VPC_ENDPOINT_ASSOCIATION_ARN_FIELD);
        map.put("VpcEndpointId", VPC_ENDPOINT_ID_FIELD);
        map.put("FlowOperationId", FLOW_OPERATION_ID_FIELD);
        map.put("FlowOperationType", FLOW_OPERATION_TYPE_FIELD);
        map.put("FlowOperationStatus", FLOW_OPERATION_STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("FlowRequestTimestamp", FLOW_REQUEST_TIMESTAMP_FIELD);
        map.put("FlowOperation", FLOW_OPERATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFlowOperationResponse, T> g) {
        return obj -> g.apply((DescribeFlowOperationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallResponse.BuilderImpl
    implements Builder {
        private String firewallArn;
        private String availabilityZone;
        private String vpcEndpointAssociationArn;
        private String vpcEndpointId;
        private String flowOperationId;
        private String flowOperationType;
        private String flowOperationStatus;
        private String statusMessage;
        private Instant flowRequestTimestamp;
        private FlowOperation flowOperation;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFlowOperationResponse model) {
            super(model);
            this.firewallArn(model.firewallArn);
            this.availabilityZone(model.availabilityZone);
            this.vpcEndpointAssociationArn(model.vpcEndpointAssociationArn);
            this.vpcEndpointId(model.vpcEndpointId);
            this.flowOperationId(model.flowOperationId);
            this.flowOperationType(model.flowOperationType);
            this.flowOperationStatus(model.flowOperationStatus);
            this.statusMessage(model.statusMessage);
            this.flowRequestTimestamp(model.flowRequestTimestamp);
            this.flowOperation(model.flowOperation);
        }

        public final String getFirewallArn() {
            return this.firewallArn;
        }

        public final void setFirewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
        }

        @Override
        public final Builder firewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getVpcEndpointAssociationArn() {
            return this.vpcEndpointAssociationArn;
        }

        public final void setVpcEndpointAssociationArn(String vpcEndpointAssociationArn) {
            this.vpcEndpointAssociationArn = vpcEndpointAssociationArn;
        }

        @Override
        public final Builder vpcEndpointAssociationArn(String vpcEndpointAssociationArn) {
            this.vpcEndpointAssociationArn = vpcEndpointAssociationArn;
            return this;
        }

        public final String getVpcEndpointId() {
            return this.vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final String getFlowOperationId() {
            return this.flowOperationId;
        }

        public final void setFlowOperationId(String flowOperationId) {
            this.flowOperationId = flowOperationId;
        }

        @Override
        public final Builder flowOperationId(String flowOperationId) {
            this.flowOperationId = flowOperationId;
            return this;
        }

        public final String getFlowOperationType() {
            return this.flowOperationType;
        }

        public final void setFlowOperationType(String flowOperationType) {
            this.flowOperationType = flowOperationType;
        }

        @Override
        public final Builder flowOperationType(String flowOperationType) {
            this.flowOperationType = flowOperationType;
            return this;
        }

        @Override
        public final Builder flowOperationType(FlowOperationType flowOperationType) {
            this.flowOperationType(flowOperationType == null ? null : flowOperationType.toString());
            return this;
        }

        public final String getFlowOperationStatus() {
            return this.flowOperationStatus;
        }

        public final void setFlowOperationStatus(String flowOperationStatus) {
            this.flowOperationStatus = flowOperationStatus;
        }

        @Override
        public final Builder flowOperationStatus(String flowOperationStatus) {
            this.flowOperationStatus = flowOperationStatus;
            return this;
        }

        @Override
        public final Builder flowOperationStatus(FlowOperationStatus flowOperationStatus) {
            this.flowOperationStatus(flowOperationStatus == null ? null : flowOperationStatus.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getFlowRequestTimestamp() {
            return this.flowRequestTimestamp;
        }

        public final void setFlowRequestTimestamp(Instant flowRequestTimestamp) {
            this.flowRequestTimestamp = flowRequestTimestamp;
        }

        @Override
        public final Builder flowRequestTimestamp(Instant flowRequestTimestamp) {
            this.flowRequestTimestamp = flowRequestTimestamp;
            return this;
        }

        public final FlowOperation.Builder getFlowOperation() {
            return this.flowOperation != null ? this.flowOperation.toBuilder() : null;
        }

        public final void setFlowOperation(FlowOperation.BuilderImpl flowOperation) {
            this.flowOperation = flowOperation != null ? flowOperation.build() : null;
        }

        @Override
        public final Builder flowOperation(FlowOperation flowOperation) {
            this.flowOperation = flowOperation;
            return this;
        }

        @Override
        public DescribeFlowOperationResponse build() {
            return new DescribeFlowOperationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkFirewallResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFlowOperationResponse> {
        public Builder firewallArn(String var1);

        public Builder availabilityZone(String var1);

        public Builder vpcEndpointAssociationArn(String var1);

        public Builder vpcEndpointId(String var1);

        public Builder flowOperationId(String var1);

        public Builder flowOperationType(String var1);

        public Builder flowOperationType(FlowOperationType var1);

        public Builder flowOperationStatus(String var1);

        public Builder flowOperationStatus(FlowOperationStatus var1);

        public Builder statusMessage(String var1);

        public Builder flowRequestTimestamp(Instant var1);

        public Builder flowOperation(FlowOperation var1);

        default public Builder flowOperation(Consumer<FlowOperation.Builder> flowOperation) {
            return this.flowOperation((FlowOperation)((FlowOperation.Builder)FlowOperation.builder().applyMutation(flowOperation)).build());
        }
    }
}

