/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.ResourceArnListCopier;
import software.amazon.awssdk.services.networkfirewall.model.ResourceNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetachRuleGroupsFromProxyConfigurationRequest
extends NetworkFirewallRequest
implements ToCopyableBuilder<Builder, DetachRuleGroupsFromProxyConfigurationRequest> {
    private static final SdkField<String> PROXY_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyConfigurationName").getter(DetachRuleGroupsFromProxyConfigurationRequest.getter(DetachRuleGroupsFromProxyConfigurationRequest::proxyConfigurationName)).setter(DetachRuleGroupsFromProxyConfigurationRequest.setter(Builder::proxyConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyConfigurationName").build()}).build();
    private static final SdkField<String> PROXY_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyConfigurationArn").getter(DetachRuleGroupsFromProxyConfigurationRequest.getter(DetachRuleGroupsFromProxyConfigurationRequest::proxyConfigurationArn)).setter(DetachRuleGroupsFromProxyConfigurationRequest.setter(Builder::proxyConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyConfigurationArn").build()}).build();
    private static final SdkField<List<String>> RULE_GROUP_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RuleGroupNames").getter(DetachRuleGroupsFromProxyConfigurationRequest.getter(DetachRuleGroupsFromProxyConfigurationRequest::ruleGroupNames)).setter(DetachRuleGroupsFromProxyConfigurationRequest.setter(Builder::ruleGroupNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RULE_GROUP_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RuleGroupArns").getter(DetachRuleGroupsFromProxyConfigurationRequest.getter(DetachRuleGroupsFromProxyConfigurationRequest::ruleGroupArns)).setter(DetachRuleGroupsFromProxyConfigurationRequest.setter(Builder::ruleGroupArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateToken").getter(DetachRuleGroupsFromProxyConfigurationRequest.getter(DetachRuleGroupsFromProxyConfigurationRequest::updateToken)).setter(DetachRuleGroupsFromProxyConfigurationRequest.setter(Builder::updateToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXY_CONFIGURATION_NAME_FIELD, PROXY_CONFIGURATION_ARN_FIELD, RULE_GROUP_NAMES_FIELD, RULE_GROUP_ARNS_FIELD, UPDATE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DetachRuleGroupsFromProxyConfigurationRequest.memberNameToFieldInitializer();
    private final String proxyConfigurationName;
    private final String proxyConfigurationArn;
    private final List<String> ruleGroupNames;
    private final List<String> ruleGroupArns;
    private final String updateToken;

    private DetachRuleGroupsFromProxyConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.proxyConfigurationName = builder.proxyConfigurationName;
        this.proxyConfigurationArn = builder.proxyConfigurationArn;
        this.ruleGroupNames = builder.ruleGroupNames;
        this.ruleGroupArns = builder.ruleGroupArns;
        this.updateToken = builder.updateToken;
    }

    public final String proxyConfigurationName() {
        return this.proxyConfigurationName;
    }

    public final String proxyConfigurationArn() {
        return this.proxyConfigurationArn;
    }

    public final boolean hasRuleGroupNames() {
        return this.ruleGroupNames != null && !(this.ruleGroupNames instanceof SdkAutoConstructList);
    }

    public final List<String> ruleGroupNames() {
        return this.ruleGroupNames;
    }

    public final boolean hasRuleGroupArns() {
        return this.ruleGroupArns != null && !(this.ruleGroupArns instanceof SdkAutoConstructList);
    }

    public final List<String> ruleGroupArns() {
        return this.ruleGroupArns;
    }

    public final String updateToken() {
        return this.updateToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleGroupNames() ? this.ruleGroupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleGroupArns() ? this.ruleGroupArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updateToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachRuleGroupsFromProxyConfigurationRequest)) {
            return false;
        }
        DetachRuleGroupsFromProxyConfigurationRequest other = (DetachRuleGroupsFromProxyConfigurationRequest)((Object)obj);
        return Objects.equals(this.proxyConfigurationName(), other.proxyConfigurationName()) && Objects.equals(this.proxyConfigurationArn(), other.proxyConfigurationArn()) && this.hasRuleGroupNames() == other.hasRuleGroupNames() && Objects.equals(this.ruleGroupNames(), other.ruleGroupNames()) && this.hasRuleGroupArns() == other.hasRuleGroupArns() && Objects.equals(this.ruleGroupArns(), other.ruleGroupArns()) && Objects.equals(this.updateToken(), other.updateToken());
    }

    public final String toString() {
        return ToString.builder((String)"DetachRuleGroupsFromProxyConfigurationRequest").add("ProxyConfigurationName", (Object)this.proxyConfigurationName()).add("ProxyConfigurationArn", (Object)this.proxyConfigurationArn()).add("RuleGroupNames", this.hasRuleGroupNames() ? this.ruleGroupNames() : null).add("RuleGroupArns", this.hasRuleGroupArns() ? this.ruleGroupArns() : null).add("UpdateToken", (Object)this.updateToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProxyConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.proxyConfigurationName()));
            }
            case "ProxyConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.proxyConfigurationArn()));
            }
            case "RuleGroupNames": {
                return Optional.ofNullable(clazz.cast(this.ruleGroupNames()));
            }
            case "RuleGroupArns": {
                return Optional.ofNullable(clazz.cast(this.ruleGroupArns()));
            }
            case "UpdateToken": {
                return Optional.ofNullable(clazz.cast(this.updateToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProxyConfigurationName", PROXY_CONFIGURATION_NAME_FIELD);
        map.put("ProxyConfigurationArn", PROXY_CONFIGURATION_ARN_FIELD);
        map.put("RuleGroupNames", RULE_GROUP_NAMES_FIELD);
        map.put("RuleGroupArns", RULE_GROUP_ARNS_FIELD);
        map.put("UpdateToken", UPDATE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetachRuleGroupsFromProxyConfigurationRequest, T> g) {
        return obj -> g.apply((DetachRuleGroupsFromProxyConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallRequest.BuilderImpl
    implements Builder {
        private String proxyConfigurationName;
        private String proxyConfigurationArn;
        private List<String> ruleGroupNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> ruleGroupArns = DefaultSdkAutoConstructList.getInstance();
        private String updateToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachRuleGroupsFromProxyConfigurationRequest model) {
            super(model);
            this.proxyConfigurationName(model.proxyConfigurationName);
            this.proxyConfigurationArn(model.proxyConfigurationArn);
            this.ruleGroupNames(model.ruleGroupNames);
            this.ruleGroupArns(model.ruleGroupArns);
            this.updateToken(model.updateToken);
        }

        public final String getProxyConfigurationName() {
            return this.proxyConfigurationName;
        }

        public final void setProxyConfigurationName(String proxyConfigurationName) {
            this.proxyConfigurationName = proxyConfigurationName;
        }

        @Override
        public final Builder proxyConfigurationName(String proxyConfigurationName) {
            this.proxyConfigurationName = proxyConfigurationName;
            return this;
        }

        public final String getProxyConfigurationArn() {
            return this.proxyConfigurationArn;
        }

        public final void setProxyConfigurationArn(String proxyConfigurationArn) {
            this.proxyConfigurationArn = proxyConfigurationArn;
        }

        @Override
        public final Builder proxyConfigurationArn(String proxyConfigurationArn) {
            this.proxyConfigurationArn = proxyConfigurationArn;
            return this;
        }

        public final Collection<String> getRuleGroupNames() {
            if (this.ruleGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ruleGroupNames;
        }

        public final void setRuleGroupNames(Collection<String> ruleGroupNames) {
            this.ruleGroupNames = ResourceNameListCopier.copy(ruleGroupNames);
        }

        @Override
        public final Builder ruleGroupNames(Collection<String> ruleGroupNames) {
            this.ruleGroupNames = ResourceNameListCopier.copy(ruleGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroupNames(String ... ruleGroupNames) {
            this.ruleGroupNames(Arrays.asList(ruleGroupNames));
            return this;
        }

        public final Collection<String> getRuleGroupArns() {
            if (this.ruleGroupArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ruleGroupArns;
        }

        public final void setRuleGroupArns(Collection<String> ruleGroupArns) {
            this.ruleGroupArns = ResourceArnListCopier.copy(ruleGroupArns);
        }

        @Override
        public final Builder ruleGroupArns(Collection<String> ruleGroupArns) {
            this.ruleGroupArns = ResourceArnListCopier.copy(ruleGroupArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroupArns(String ... ruleGroupArns) {
            this.ruleGroupArns(Arrays.asList(ruleGroupArns));
            return this;
        }

        public final String getUpdateToken() {
            return this.updateToken;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetachRuleGroupsFromProxyConfigurationRequest build() {
            return new DetachRuleGroupsFromProxyConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkFirewallRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DetachRuleGroupsFromProxyConfigurationRequest> {
        public Builder proxyConfigurationName(String var1);

        public Builder proxyConfigurationArn(String var1);

        public Builder ruleGroupNames(Collection<String> var1);

        public Builder ruleGroupNames(String ... var1);

        public Builder ruleGroupArns(Collection<String> var1);

        public Builder ruleGroupArns(String ... var1);

        public Builder updateToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

