/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkfirewall.model.FlowOperationStatus;
import software.amazon.awssdk.services.networkfirewall.model.FlowOperationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlowOperationMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlowOperationMetadata> {
    private static final SdkField<String> FLOW_OPERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowOperationId").getter(FlowOperationMetadata.getter(FlowOperationMetadata::flowOperationId)).setter(FlowOperationMetadata.setter(Builder::flowOperationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowOperationId").build()}).build();
    private static final SdkField<String> FLOW_OPERATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowOperationType").getter(FlowOperationMetadata.getter(FlowOperationMetadata::flowOperationTypeAsString)).setter(FlowOperationMetadata.setter(Builder::flowOperationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowOperationType").build()}).build();
    private static final SdkField<Instant> FLOW_REQUEST_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("FlowRequestTimestamp").getter(FlowOperationMetadata.getter(FlowOperationMetadata::flowRequestTimestamp)).setter(FlowOperationMetadata.setter(Builder::flowRequestTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowRequestTimestamp").build()}).build();
    private static final SdkField<String> FLOW_OPERATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowOperationStatus").getter(FlowOperationMetadata.getter(FlowOperationMetadata::flowOperationStatusAsString)).setter(FlowOperationMetadata.setter(Builder::flowOperationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowOperationStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_OPERATION_ID_FIELD, FLOW_OPERATION_TYPE_FIELD, FLOW_REQUEST_TIMESTAMP_FIELD, FLOW_OPERATION_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FlowOperationMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String flowOperationId;
    private final String flowOperationType;
    private final Instant flowRequestTimestamp;
    private final String flowOperationStatus;

    private FlowOperationMetadata(BuilderImpl builder) {
        this.flowOperationId = builder.flowOperationId;
        this.flowOperationType = builder.flowOperationType;
        this.flowRequestTimestamp = builder.flowRequestTimestamp;
        this.flowOperationStatus = builder.flowOperationStatus;
    }

    public final String flowOperationId() {
        return this.flowOperationId;
    }

    public final FlowOperationType flowOperationType() {
        return FlowOperationType.fromValue(this.flowOperationType);
    }

    public final String flowOperationTypeAsString() {
        return this.flowOperationType;
    }

    public final Instant flowRequestTimestamp() {
        return this.flowRequestTimestamp;
    }

    public final FlowOperationStatus flowOperationStatus() {
        return FlowOperationStatus.fromValue(this.flowOperationStatus);
    }

    public final String flowOperationStatusAsString() {
        return this.flowOperationStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.flowOperationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowOperationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowRequestTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowOperationStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowOperationMetadata)) {
            return false;
        }
        FlowOperationMetadata other = (FlowOperationMetadata)obj;
        return Objects.equals(this.flowOperationId(), other.flowOperationId()) && Objects.equals(this.flowOperationTypeAsString(), other.flowOperationTypeAsString()) && Objects.equals(this.flowRequestTimestamp(), other.flowRequestTimestamp()) && Objects.equals(this.flowOperationStatusAsString(), other.flowOperationStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FlowOperationMetadata").add("FlowOperationId", (Object)this.flowOperationId()).add("FlowOperationType", (Object)this.flowOperationTypeAsString()).add("FlowRequestTimestamp", (Object)this.flowRequestTimestamp()).add("FlowOperationStatus", (Object)this.flowOperationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlowOperationId": {
                return Optional.ofNullable(clazz.cast(this.flowOperationId()));
            }
            case "FlowOperationType": {
                return Optional.ofNullable(clazz.cast(this.flowOperationTypeAsString()));
            }
            case "FlowRequestTimestamp": {
                return Optional.ofNullable(clazz.cast(this.flowRequestTimestamp()));
            }
            case "FlowOperationStatus": {
                return Optional.ofNullable(clazz.cast(this.flowOperationStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FlowOperationId", FLOW_OPERATION_ID_FIELD);
        map.put("FlowOperationType", FLOW_OPERATION_TYPE_FIELD);
        map.put("FlowRequestTimestamp", FLOW_REQUEST_TIMESTAMP_FIELD);
        map.put("FlowOperationStatus", FLOW_OPERATION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowOperationMetadata, T> g) {
        return obj -> g.apply((FlowOperationMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String flowOperationId;
        private String flowOperationType;
        private Instant flowRequestTimestamp;
        private String flowOperationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowOperationMetadata model) {
            this.flowOperationId(model.flowOperationId);
            this.flowOperationType(model.flowOperationType);
            this.flowRequestTimestamp(model.flowRequestTimestamp);
            this.flowOperationStatus(model.flowOperationStatus);
        }

        public final String getFlowOperationId() {
            return this.flowOperationId;
        }

        public final void setFlowOperationId(String flowOperationId) {
            this.flowOperationId = flowOperationId;
        }

        @Override
        public final Builder flowOperationId(String flowOperationId) {
            this.flowOperationId = flowOperationId;
            return this;
        }

        public final String getFlowOperationType() {
            return this.flowOperationType;
        }

        public final void setFlowOperationType(String flowOperationType) {
            this.flowOperationType = flowOperationType;
        }

        @Override
        public final Builder flowOperationType(String flowOperationType) {
            this.flowOperationType = flowOperationType;
            return this;
        }

        @Override
        public final Builder flowOperationType(FlowOperationType flowOperationType) {
            this.flowOperationType(flowOperationType == null ? null : flowOperationType.toString());
            return this;
        }

        public final Instant getFlowRequestTimestamp() {
            return this.flowRequestTimestamp;
        }

        public final void setFlowRequestTimestamp(Instant flowRequestTimestamp) {
            this.flowRequestTimestamp = flowRequestTimestamp;
        }

        @Override
        public final Builder flowRequestTimestamp(Instant flowRequestTimestamp) {
            this.flowRequestTimestamp = flowRequestTimestamp;
            return this;
        }

        public final String getFlowOperationStatus() {
            return this.flowOperationStatus;
        }

        public final void setFlowOperationStatus(String flowOperationStatus) {
            this.flowOperationStatus = flowOperationStatus;
        }

        @Override
        public final Builder flowOperationStatus(String flowOperationStatus) {
            this.flowOperationStatus = flowOperationStatus;
            return this;
        }

        @Override
        public final Builder flowOperationStatus(FlowOperationStatus flowOperationStatus) {
            this.flowOperationStatus(flowOperationStatus == null ? null : flowOperationStatus.toString());
            return this;
        }

        public FlowOperationMetadata build() {
            return new FlowOperationMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlowOperationMetadata> {
        public Builder flowOperationId(String var1);

        public Builder flowOperationType(String var1);

        public Builder flowOperationType(FlowOperationType var1);

        public Builder flowRequestTimestamp(Instant var1);

        public Builder flowOperationStatus(String var1);

        public Builder flowOperationStatus(FlowOperationStatus var1);
    }
}

