/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallResponse;
import software.amazon.awssdk.services.networkfirewall.model.ProxiesCopier;
import software.amazon.awssdk.services.networkfirewall.model.ProxyMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProxiesResponse
extends NetworkFirewallResponse
implements ToCopyableBuilder<Builder, ListProxiesResponse> {
    private static final SdkField<List<ProxyMetadata>> PROXIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Proxies").getter(ListProxiesResponse.getter(ListProxiesResponse::proxies)).setter(ListProxiesResponse.setter(Builder::proxies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Proxies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProxyMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListProxiesResponse.getter(ListProxiesResponse::nextToken)).setter(ListProxiesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListProxiesResponse.memberNameToFieldInitializer();
    private final List<ProxyMetadata> proxies;
    private final String nextToken;

    private ListProxiesResponse(BuilderImpl builder) {
        super(builder);
        this.proxies = builder.proxies;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasProxies() {
        return this.proxies != null && !(this.proxies instanceof SdkAutoConstructList);
    }

    public final List<ProxyMetadata> proxies() {
        return this.proxies;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProxies() ? this.proxies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProxiesResponse)) {
            return false;
        }
        ListProxiesResponse other = (ListProxiesResponse)((Object)obj);
        return this.hasProxies() == other.hasProxies() && Objects.equals(this.proxies(), other.proxies()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListProxiesResponse").add("Proxies", this.hasProxies() ? this.proxies() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Proxies": {
                return Optional.ofNullable(clazz.cast(this.proxies()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Proxies", PROXIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListProxiesResponse, T> g) {
        return obj -> g.apply((ListProxiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallResponse.BuilderImpl
    implements Builder {
        private List<ProxyMetadata> proxies = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProxiesResponse model) {
            super(model);
            this.proxies(model.proxies);
            this.nextToken(model.nextToken);
        }

        public final List<ProxyMetadata.Builder> getProxies() {
            List<ProxyMetadata.Builder> result = ProxiesCopier.copyToBuilder(this.proxies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProxies(Collection<ProxyMetadata.BuilderImpl> proxies) {
            this.proxies = ProxiesCopier.copyFromBuilder(proxies);
        }

        @Override
        public final Builder proxies(Collection<ProxyMetadata> proxies) {
            this.proxies = ProxiesCopier.copy(proxies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proxies(ProxyMetadata ... proxies) {
            this.proxies(Arrays.asList(proxies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proxies(Consumer<ProxyMetadata.Builder> ... proxies) {
            this.proxies(Stream.of(proxies).map(c -> (ProxyMetadata)((ProxyMetadata.Builder)ProxyMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListProxiesResponse build() {
            return new ListProxiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkFirewallResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProxiesResponse> {
        public Builder proxies(Collection<ProxyMetadata> var1);

        public Builder proxies(ProxyMetadata ... var1);

        public Builder proxies(Consumer<ProxyMetadata.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

