/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.networkfirewall.model.IPSet;
import software.amazon.awssdk.services.networkfirewall.model.IPSetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PolicyVariables
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PolicyVariables> {
    private static final SdkField<Map<String, IPSet>> RULE_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("RuleVariables").getter(PolicyVariables.getter(PolicyVariables::ruleVariables)).setter(PolicyVariables.setter(Builder::ruleVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IPSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_VARIABLES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PolicyVariables.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, IPSet> ruleVariables;

    private PolicyVariables(BuilderImpl builder) {
        this.ruleVariables = builder.ruleVariables;
    }

    public final boolean hasRuleVariables() {
        return this.ruleVariables != null && !(this.ruleVariables instanceof SdkAutoConstructMap);
    }

    public final Map<String, IPSet> ruleVariables() {
        return this.ruleVariables;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleVariables() ? this.ruleVariables() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyVariables)) {
            return false;
        }
        PolicyVariables other = (PolicyVariables)obj;
        return this.hasRuleVariables() == other.hasRuleVariables() && Objects.equals(this.ruleVariables(), other.ruleVariables());
    }

    public final String toString() {
        return ToString.builder((String)"PolicyVariables").add("RuleVariables", this.hasRuleVariables() ? this.ruleVariables() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleVariables": {
                return Optional.ofNullable(clazz.cast(this.ruleVariables()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Map<String, IPSet>>> map = new HashMap<String, SdkField<Map<String, IPSet>>>();
        map.put("RuleVariables", RULE_VARIABLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PolicyVariables, T> g) {
        return obj -> g.apply((PolicyVariables)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, IPSet> ruleVariables = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyVariables model) {
            this.ruleVariables(model.ruleVariables);
        }

        public final Map<String, IPSet.Builder> getRuleVariables() {
            Map<String, IPSet.Builder> result = IPSetsCopier.copyToBuilder(this.ruleVariables);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setRuleVariables(Map<String, IPSet.BuilderImpl> ruleVariables) {
            this.ruleVariables = IPSetsCopier.copyFromBuilder(ruleVariables);
        }

        @Override
        public final Builder ruleVariables(Map<String, IPSet> ruleVariables) {
            this.ruleVariables = IPSetsCopier.copy(ruleVariables);
            return this;
        }

        public PolicyVariables build() {
            return new PolicyVariables(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PolicyVariables> {
        public Builder ruleVariables(Map<String, IPSet> var1);
    }
}

