/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkfirewall.model.StatefulRuleGroupOverride;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StatefulRuleGroupReference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StatefulRuleGroupReference> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(StatefulRuleGroupReference.getter(StatefulRuleGroupReference::resourceArn)).setter(StatefulRuleGroupReference.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Priority").getter(StatefulRuleGroupReference.getter(StatefulRuleGroupReference::priority)).setter(StatefulRuleGroupReference.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()}).build();
    private static final SdkField<StatefulRuleGroupOverride> OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Override").getter(StatefulRuleGroupReference.getter(StatefulRuleGroupReference::override)).setter(StatefulRuleGroupReference.setter(Builder::override)).constructor(StatefulRuleGroupOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Override").build()}).build();
    private static final SdkField<Boolean> DEEP_THREAT_INSPECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeepThreatInspection").getter(StatefulRuleGroupReference.getter(StatefulRuleGroupReference::deepThreatInspection)).setter(StatefulRuleGroupReference.setter(Builder::deepThreatInspection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeepThreatInspection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, PRIORITY_FIELD, OVERRIDE_FIELD, DEEP_THREAT_INSPECTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StatefulRuleGroupReference.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceArn;
    private final Integer priority;
    private final StatefulRuleGroupOverride override;
    private final Boolean deepThreatInspection;

    private StatefulRuleGroupReference(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.priority = builder.priority;
        this.override = builder.override;
        this.deepThreatInspection = builder.deepThreatInspection;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final StatefulRuleGroupOverride override() {
        return this.override;
    }

    public final Boolean deepThreatInspection() {
        return this.deepThreatInspection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.override());
        hashCode = 31 * hashCode + Objects.hashCode(this.deepThreatInspection());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatefulRuleGroupReference)) {
            return false;
        }
        StatefulRuleGroupReference other = (StatefulRuleGroupReference)obj;
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.override(), other.override()) && Objects.equals(this.deepThreatInspection(), other.deepThreatInspection());
    }

    public final String toString() {
        return ToString.builder((String)"StatefulRuleGroupReference").add("ResourceArn", (Object)this.resourceArn()).add("Priority", (Object)this.priority()).add("Override", (Object)this.override()).add("DeepThreatInspection", (Object)this.deepThreatInspection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "Override": {
                return Optional.ofNullable(clazz.cast(this.override()));
            }
            case "DeepThreatInspection": {
                return Optional.ofNullable(clazz.cast(this.deepThreatInspection()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("Priority", PRIORITY_FIELD);
        map.put("Override", OVERRIDE_FIELD);
        map.put("DeepThreatInspection", DEEP_THREAT_INSPECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StatefulRuleGroupReference, T> g) {
        return obj -> g.apply((StatefulRuleGroupReference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceArn;
        private Integer priority;
        private StatefulRuleGroupOverride override;
        private Boolean deepThreatInspection;

        private BuilderImpl() {
        }

        private BuilderImpl(StatefulRuleGroupReference model) {
            this.resourceArn(model.resourceArn);
            this.priority(model.priority);
            this.override(model.override);
            this.deepThreatInspection(model.deepThreatInspection);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final StatefulRuleGroupOverride.Builder getOverride() {
            return this.override != null ? this.override.toBuilder() : null;
        }

        public final void setOverride(StatefulRuleGroupOverride.BuilderImpl override) {
            this.override = override != null ? override.build() : null;
        }

        @Override
        public final Builder override(StatefulRuleGroupOverride override) {
            this.override = override;
            return this;
        }

        public final Boolean getDeepThreatInspection() {
            return this.deepThreatInspection;
        }

        public final void setDeepThreatInspection(Boolean deepThreatInspection) {
            this.deepThreatInspection = deepThreatInspection;
        }

        @Override
        public final Builder deepThreatInspection(Boolean deepThreatInspection) {
            this.deepThreatInspection = deepThreatInspection;
            return this;
        }

        public StatefulRuleGroupReference build() {
            return new StatefulRuleGroupReference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StatefulRuleGroupReference> {
        public Builder resourceArn(String var1);

        public Builder priority(Integer var1);

        public Builder override(StatefulRuleGroupOverride var1);

        default public Builder override(Consumer<StatefulRuleGroupOverride.Builder> override) {
            return this.override((StatefulRuleGroupOverride)((StatefulRuleGroupOverride.Builder)StatefulRuleGroupOverride.builder().applyMutation(override)).build());
        }

        public Builder deepThreatInspection(Boolean var1);
    }
}

