/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StatefulRuleProtocol {
    IP("IP"),
    TCP("TCP"),
    UDP("UDP"),
    ICMP("ICMP"),
    HTTP("HTTP"),
    FTP("FTP"),
    TLS("TLS"),
    SMB("SMB"),
    DNS("DNS"),
    DCERPC("DCERPC"),
    SSH("SSH"),
    SMTP("SMTP"),
    IMAP("IMAP"),
    MSN("MSN"),
    KRB5("KRB5"),
    IKEV2("IKEV2"),
    TFTP("TFTP"),
    NTP("NTP"),
    DHCP("DHCP"),
    HTTP2("HTTP2"),
    QUIC("QUIC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StatefulRuleProtocol> VALUE_MAP;
    private final String value;

    private StatefulRuleProtocol(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StatefulRuleProtocol fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StatefulRuleProtocol> knownValues() {
        EnumSet<StatefulRuleProtocol> knownValues = EnumSet.allOf(StatefulRuleProtocol.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StatefulRuleProtocol.class, StatefulRuleProtocol::toString);
    }
}

