/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkfirewall.model.TlsInterceptMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TlsInterceptProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TlsInterceptProperties> {
    private static final SdkField<String> PCA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PcaArn").getter(TlsInterceptProperties.getter(TlsInterceptProperties::pcaArn)).setter(TlsInterceptProperties.setter(Builder::pcaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PcaArn").build()}).build();
    private static final SdkField<String> TLS_INTERCEPT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TlsInterceptMode").getter(TlsInterceptProperties.getter(TlsInterceptProperties::tlsInterceptModeAsString)).setter(TlsInterceptProperties.setter(Builder::tlsInterceptMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TlsInterceptMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PCA_ARN_FIELD, TLS_INTERCEPT_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TlsInterceptProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String pcaArn;
    private final String tlsInterceptMode;

    private TlsInterceptProperties(BuilderImpl builder) {
        this.pcaArn = builder.pcaArn;
        this.tlsInterceptMode = builder.tlsInterceptMode;
    }

    public final String pcaArn() {
        return this.pcaArn;
    }

    public final TlsInterceptMode tlsInterceptMode() {
        return TlsInterceptMode.fromValue(this.tlsInterceptMode);
    }

    public final String tlsInterceptModeAsString() {
        return this.tlsInterceptMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pcaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tlsInterceptModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TlsInterceptProperties)) {
            return false;
        }
        TlsInterceptProperties other = (TlsInterceptProperties)obj;
        return Objects.equals(this.pcaArn(), other.pcaArn()) && Objects.equals(this.tlsInterceptModeAsString(), other.tlsInterceptModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TlsInterceptProperties").add("PcaArn", (Object)this.pcaArn()).add("TlsInterceptMode", (Object)this.tlsInterceptModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PcaArn": {
                return Optional.ofNullable(clazz.cast(this.pcaArn()));
            }
            case "TlsInterceptMode": {
                return Optional.ofNullable(clazz.cast(this.tlsInterceptModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("PcaArn", PCA_ARN_FIELD);
        map.put("TlsInterceptMode", TLS_INTERCEPT_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TlsInterceptProperties, T> g) {
        return obj -> g.apply((TlsInterceptProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pcaArn;
        private String tlsInterceptMode;

        private BuilderImpl() {
        }

        private BuilderImpl(TlsInterceptProperties model) {
            this.pcaArn(model.pcaArn);
            this.tlsInterceptMode(model.tlsInterceptMode);
        }

        public final String getPcaArn() {
            return this.pcaArn;
        }

        public final void setPcaArn(String pcaArn) {
            this.pcaArn = pcaArn;
        }

        @Override
        public final Builder pcaArn(String pcaArn) {
            this.pcaArn = pcaArn;
            return this;
        }

        public final String getTlsInterceptMode() {
            return this.tlsInterceptMode;
        }

        public final void setTlsInterceptMode(String tlsInterceptMode) {
            this.tlsInterceptMode = tlsInterceptMode;
        }

        @Override
        public final Builder tlsInterceptMode(String tlsInterceptMode) {
            this.tlsInterceptMode = tlsInterceptMode;
            return this;
        }

        @Override
        public final Builder tlsInterceptMode(TlsInterceptMode tlsInterceptMode) {
            this.tlsInterceptMode(tlsInterceptMode == null ? null : tlsInterceptMode.toString());
            return this;
        }

        public TlsInterceptProperties build() {
            return new TlsInterceptProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TlsInterceptProperties> {
        public Builder pcaArn(String var1);

        public Builder tlsInterceptMode(String var1);

        public Builder tlsInterceptMode(TlsInterceptMode var1);
    }
}

