/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.ProxyRuleCondition;
import software.amazon.awssdk.services.networkfirewall.model.ProxyRuleConditionListCopier;
import software.amazon.awssdk.services.networkfirewall.model.ProxyRulePhaseAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProxyRuleRequest
extends NetworkFirewallRequest
implements ToCopyableBuilder<Builder, UpdateProxyRuleRequest> {
    private static final SdkField<String> PROXY_RULE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyRuleGroupName").getter(UpdateProxyRuleRequest.getter(UpdateProxyRuleRequest::proxyRuleGroupName)).setter(UpdateProxyRuleRequest.setter(Builder::proxyRuleGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyRuleGroupName").build()}).build();
    private static final SdkField<String> PROXY_RULE_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyRuleGroupArn").getter(UpdateProxyRuleRequest.getter(UpdateProxyRuleRequest::proxyRuleGroupArn)).setter(UpdateProxyRuleRequest.setter(Builder::proxyRuleGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyRuleGroupArn").build()}).build();
    private static final SdkField<String> PROXY_RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyRuleName").getter(UpdateProxyRuleRequest.getter(UpdateProxyRuleRequest::proxyRuleName)).setter(UpdateProxyRuleRequest.setter(Builder::proxyRuleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyRuleName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateProxyRuleRequest.getter(UpdateProxyRuleRequest::description)).setter(UpdateProxyRuleRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(UpdateProxyRuleRequest.getter(UpdateProxyRuleRequest::actionAsString)).setter(UpdateProxyRuleRequest.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<List<ProxyRuleCondition>> ADD_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddConditions").getter(UpdateProxyRuleRequest.getter(UpdateProxyRuleRequest::addConditions)).setter(UpdateProxyRuleRequest.setter(Builder::addConditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddConditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProxyRuleCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ProxyRuleCondition>> REMOVE_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveConditions").getter(UpdateProxyRuleRequest.getter(UpdateProxyRuleRequest::removeConditions)).setter(UpdateProxyRuleRequest.setter(Builder::removeConditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveConditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProxyRuleCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateToken").getter(UpdateProxyRuleRequest.getter(UpdateProxyRuleRequest::updateToken)).setter(UpdateProxyRuleRequest.setter(Builder::updateToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXY_RULE_GROUP_NAME_FIELD, PROXY_RULE_GROUP_ARN_FIELD, PROXY_RULE_NAME_FIELD, DESCRIPTION_FIELD, ACTION_FIELD, ADD_CONDITIONS_FIELD, REMOVE_CONDITIONS_FIELD, UPDATE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateProxyRuleRequest.memberNameToFieldInitializer();
    private final String proxyRuleGroupName;
    private final String proxyRuleGroupArn;
    private final String proxyRuleName;
    private final String description;
    private final String action;
    private final List<ProxyRuleCondition> addConditions;
    private final List<ProxyRuleCondition> removeConditions;
    private final String updateToken;

    private UpdateProxyRuleRequest(BuilderImpl builder) {
        super(builder);
        this.proxyRuleGroupName = builder.proxyRuleGroupName;
        this.proxyRuleGroupArn = builder.proxyRuleGroupArn;
        this.proxyRuleName = builder.proxyRuleName;
        this.description = builder.description;
        this.action = builder.action;
        this.addConditions = builder.addConditions;
        this.removeConditions = builder.removeConditions;
        this.updateToken = builder.updateToken;
    }

    public final String proxyRuleGroupName() {
        return this.proxyRuleGroupName;
    }

    public final String proxyRuleGroupArn() {
        return this.proxyRuleGroupArn;
    }

    public final String proxyRuleName() {
        return this.proxyRuleName;
    }

    public final String description() {
        return this.description;
    }

    public final ProxyRulePhaseAction action() {
        return ProxyRulePhaseAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final boolean hasAddConditions() {
        return this.addConditions != null && !(this.addConditions instanceof SdkAutoConstructList);
    }

    public final List<ProxyRuleCondition> addConditions() {
        return this.addConditions;
    }

    public final boolean hasRemoveConditions() {
        return this.removeConditions != null && !(this.removeConditions instanceof SdkAutoConstructList);
    }

    public final List<ProxyRuleCondition> removeConditions() {
        return this.removeConditions;
    }

    public final String updateToken() {
        return this.updateToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyRuleGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyRuleGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddConditions() ? this.addConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveConditions() ? this.removeConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updateToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProxyRuleRequest)) {
            return false;
        }
        UpdateProxyRuleRequest other = (UpdateProxyRuleRequest)((Object)obj);
        return Objects.equals(this.proxyRuleGroupName(), other.proxyRuleGroupName()) && Objects.equals(this.proxyRuleGroupArn(), other.proxyRuleGroupArn()) && Objects.equals(this.proxyRuleName(), other.proxyRuleName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.actionAsString(), other.actionAsString()) && this.hasAddConditions() == other.hasAddConditions() && Objects.equals(this.addConditions(), other.addConditions()) && this.hasRemoveConditions() == other.hasRemoveConditions() && Objects.equals(this.removeConditions(), other.removeConditions()) && Objects.equals(this.updateToken(), other.updateToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateProxyRuleRequest").add("ProxyRuleGroupName", (Object)this.proxyRuleGroupName()).add("ProxyRuleGroupArn", (Object)this.proxyRuleGroupArn()).add("ProxyRuleName", (Object)this.proxyRuleName()).add("Description", (Object)this.description()).add("Action", (Object)this.actionAsString()).add("AddConditions", this.hasAddConditions() ? this.addConditions() : null).add("RemoveConditions", this.hasRemoveConditions() ? this.removeConditions() : null).add("UpdateToken", (Object)this.updateToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProxyRuleGroupName": {
                return Optional.ofNullable(clazz.cast(this.proxyRuleGroupName()));
            }
            case "ProxyRuleGroupArn": {
                return Optional.ofNullable(clazz.cast(this.proxyRuleGroupArn()));
            }
            case "ProxyRuleName": {
                return Optional.ofNullable(clazz.cast(this.proxyRuleName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "AddConditions": {
                return Optional.ofNullable(clazz.cast(this.addConditions()));
            }
            case "RemoveConditions": {
                return Optional.ofNullable(clazz.cast(this.removeConditions()));
            }
            case "UpdateToken": {
                return Optional.ofNullable(clazz.cast(this.updateToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProxyRuleGroupName", PROXY_RULE_GROUP_NAME_FIELD);
        map.put("ProxyRuleGroupArn", PROXY_RULE_GROUP_ARN_FIELD);
        map.put("ProxyRuleName", PROXY_RULE_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Action", ACTION_FIELD);
        map.put("AddConditions", ADD_CONDITIONS_FIELD);
        map.put("RemoveConditions", REMOVE_CONDITIONS_FIELD);
        map.put("UpdateToken", UPDATE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProxyRuleRequest, T> g) {
        return obj -> g.apply((UpdateProxyRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallRequest.BuilderImpl
    implements Builder {
        private String proxyRuleGroupName;
        private String proxyRuleGroupArn;
        private String proxyRuleName;
        private String description;
        private String action;
        private List<ProxyRuleCondition> addConditions = DefaultSdkAutoConstructList.getInstance();
        private List<ProxyRuleCondition> removeConditions = DefaultSdkAutoConstructList.getInstance();
        private String updateToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProxyRuleRequest model) {
            super(model);
            this.proxyRuleGroupName(model.proxyRuleGroupName);
            this.proxyRuleGroupArn(model.proxyRuleGroupArn);
            this.proxyRuleName(model.proxyRuleName);
            this.description(model.description);
            this.action(model.action);
            this.addConditions(model.addConditions);
            this.removeConditions(model.removeConditions);
            this.updateToken(model.updateToken);
        }

        public final String getProxyRuleGroupName() {
            return this.proxyRuleGroupName;
        }

        public final void setProxyRuleGroupName(String proxyRuleGroupName) {
            this.proxyRuleGroupName = proxyRuleGroupName;
        }

        @Override
        public final Builder proxyRuleGroupName(String proxyRuleGroupName) {
            this.proxyRuleGroupName = proxyRuleGroupName;
            return this;
        }

        public final String getProxyRuleGroupArn() {
            return this.proxyRuleGroupArn;
        }

        public final void setProxyRuleGroupArn(String proxyRuleGroupArn) {
            this.proxyRuleGroupArn = proxyRuleGroupArn;
        }

        @Override
        public final Builder proxyRuleGroupArn(String proxyRuleGroupArn) {
            this.proxyRuleGroupArn = proxyRuleGroupArn;
            return this;
        }

        public final String getProxyRuleName() {
            return this.proxyRuleName;
        }

        public final void setProxyRuleName(String proxyRuleName) {
            this.proxyRuleName = proxyRuleName;
        }

        @Override
        public final Builder proxyRuleName(String proxyRuleName) {
            this.proxyRuleName = proxyRuleName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ProxyRulePhaseAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final List<ProxyRuleCondition.Builder> getAddConditions() {
            List<ProxyRuleCondition.Builder> result = ProxyRuleConditionListCopier.copyToBuilder(this.addConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddConditions(Collection<ProxyRuleCondition.BuilderImpl> addConditions) {
            this.addConditions = ProxyRuleConditionListCopier.copyFromBuilder(addConditions);
        }

        @Override
        public final Builder addConditions(Collection<ProxyRuleCondition> addConditions) {
            this.addConditions = ProxyRuleConditionListCopier.copy(addConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addConditions(ProxyRuleCondition ... addConditions) {
            this.addConditions(Arrays.asList(addConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addConditions(Consumer<ProxyRuleCondition.Builder> ... addConditions) {
            this.addConditions(Stream.of(addConditions).map(c -> (ProxyRuleCondition)((ProxyRuleCondition.Builder)ProxyRuleCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ProxyRuleCondition.Builder> getRemoveConditions() {
            List<ProxyRuleCondition.Builder> result = ProxyRuleConditionListCopier.copyToBuilder(this.removeConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemoveConditions(Collection<ProxyRuleCondition.BuilderImpl> removeConditions) {
            this.removeConditions = ProxyRuleConditionListCopier.copyFromBuilder(removeConditions);
        }

        @Override
        public final Builder removeConditions(Collection<ProxyRuleCondition> removeConditions) {
            this.removeConditions = ProxyRuleConditionListCopier.copy(removeConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeConditions(ProxyRuleCondition ... removeConditions) {
            this.removeConditions(Arrays.asList(removeConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeConditions(Consumer<ProxyRuleCondition.Builder> ... removeConditions) {
            this.removeConditions(Stream.of(removeConditions).map(c -> (ProxyRuleCondition)((ProxyRuleCondition.Builder)ProxyRuleCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUpdateToken() {
            return this.updateToken;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProxyRuleRequest build() {
            return new UpdateProxyRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkFirewallRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateProxyRuleRequest> {
        public Builder proxyRuleGroupName(String var1);

        public Builder proxyRuleGroupArn(String var1);

        public Builder proxyRuleName(String var1);

        public Builder description(String var1);

        public Builder action(String var1);

        public Builder action(ProxyRulePhaseAction var1);

        public Builder addConditions(Collection<ProxyRuleCondition> var1);

        public Builder addConditions(ProxyRuleCondition ... var1);

        public Builder addConditions(Consumer<ProxyRuleCondition.Builder> ... var1);

        public Builder removeConditions(Collection<ProxyRuleCondition> var1);

        public Builder removeConditions(ProxyRuleCondition ... var1);

        public Builder removeConditions(Consumer<ProxyRuleCondition.Builder> ... var1);

        public Builder updateToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

