/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallClient;
import software.amazon.awssdk.services.networkfirewall.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkfirewall.model.ListProxiesRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListProxiesResponse;
import software.amazon.awssdk.services.networkfirewall.model.ProxyMetadata;

public class ListProxiesIterable
implements SdkIterable<ListProxiesResponse> {
    private final NetworkFirewallClient client;
    private final ListProxiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProxiesIterable(NetworkFirewallClient client, ListProxiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListProxiesResponseFetcher();
    }

    public Iterator<ListProxiesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProxyMetadata> proxies() {
        Function<ListProxiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.proxies() != null) {
                return response.proxies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListProxiesResponseFetcher
    implements SyncPageFetcher<ListProxiesResponse> {
        private ListProxiesResponseFetcher() {
        }

        public boolean hasNextPage(ListProxiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProxiesResponse nextPage(ListProxiesResponse previousPage) {
            if (previousPage == null) {
                return ListProxiesIterable.this.client.listProxies(ListProxiesIterable.this.firstRequest);
            }
            return ListProxiesIterable.this.client.listProxies((ListProxiesRequest)((Object)ListProxiesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

