/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerResponse;
import software.amazon.awssdk.services.networkmanager.model.Peering;
import software.amazon.awssdk.services.networkmanager.model.PeeringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPeeringsResponse
extends NetworkManagerResponse
implements ToCopyableBuilder<Builder, ListPeeringsResponse> {
    private static final SdkField<List<Peering>> PEERINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Peerings").getter(ListPeeringsResponse.getter(ListPeeringsResponse::peerings)).setter(ListPeeringsResponse.setter(Builder::peerings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Peerings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Peering::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPeeringsResponse.getter(ListPeeringsResponse::nextToken)).setter(ListPeeringsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PEERINGS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPeeringsResponse.memberNameToFieldInitializer();
    private final List<Peering> peerings;
    private final String nextToken;

    private ListPeeringsResponse(BuilderImpl builder) {
        super(builder);
        this.peerings = builder.peerings;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPeerings() {
        return this.peerings != null && !(this.peerings instanceof SdkAutoConstructList);
    }

    public final List<Peering> peerings() {
        return this.peerings;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPeerings() ? this.peerings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPeeringsResponse)) {
            return false;
        }
        ListPeeringsResponse other = (ListPeeringsResponse)((Object)obj);
        return this.hasPeerings() == other.hasPeerings() && Objects.equals(this.peerings(), other.peerings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPeeringsResponse").add("Peerings", this.hasPeerings() ? this.peerings() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Peerings": {
                return Optional.ofNullable(clazz.cast(this.peerings()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Peerings", PEERINGS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPeeringsResponse, T> g) {
        return obj -> g.apply((ListPeeringsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkManagerResponse.BuilderImpl
    implements Builder {
        private List<Peering> peerings = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPeeringsResponse model) {
            super(model);
            this.peerings(model.peerings);
            this.nextToken(model.nextToken);
        }

        public final List<Peering.Builder> getPeerings() {
            List<Peering.Builder> result = PeeringListCopier.copyToBuilder(this.peerings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPeerings(Collection<Peering.BuilderImpl> peerings) {
            this.peerings = PeeringListCopier.copyFromBuilder(peerings);
        }

        @Override
        public final Builder peerings(Collection<Peering> peerings) {
            this.peerings = PeeringListCopier.copy(peerings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder peerings(Peering ... peerings) {
            this.peerings(Arrays.asList(peerings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder peerings(Consumer<Peering.Builder> ... peerings) {
            this.peerings(Stream.of(peerings).map(c -> (Peering)((Peering.Builder)Peering.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPeeringsResponse build() {
            return new ListPeeringsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NetworkManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPeeringsResponse> {
        public Builder peerings(Collection<Peering> var1);

        public Builder peerings(Peering ... var1);

        public Builder peerings(Consumer<Peering.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

