/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkmanager.model.ChangeAction;
import software.amazon.awssdk.services.networkmanager.model.ChangeType;
import software.amazon.awssdk.services.networkmanager.model.CoreNetworkChangeValues;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CoreNetworkChange
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CoreNetworkChange> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(CoreNetworkChange.getter(CoreNetworkChange::typeAsString)).setter(CoreNetworkChange.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(CoreNetworkChange.getter(CoreNetworkChange::actionAsString)).setter(CoreNetworkChange.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(CoreNetworkChange.getter(CoreNetworkChange::identifier)).setter(CoreNetworkChange.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()}).build();
    private static final SdkField<CoreNetworkChangeValues> PREVIOUS_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PreviousValues").getter(CoreNetworkChange.getter(CoreNetworkChange::previousValues)).setter(CoreNetworkChange.setter(Builder::previousValues)).constructor(CoreNetworkChangeValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousValues").build()}).build();
    private static final SdkField<CoreNetworkChangeValues> NEW_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NewValues").getter(CoreNetworkChange.getter(CoreNetworkChange::newValues)).setter(CoreNetworkChange.setter(Builder::newValues)).constructor(CoreNetworkChangeValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewValues").build()}).build();
    private static final SdkField<String> IDENTIFIER_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentifierPath").getter(CoreNetworkChange.getter(CoreNetworkChange::identifierPath)).setter(CoreNetworkChange.setter(Builder::identifierPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentifierPath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, ACTION_FIELD, IDENTIFIER_FIELD, PREVIOUS_VALUES_FIELD, NEW_VALUES_FIELD, IDENTIFIER_PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CoreNetworkChange.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String action;
    private final String identifier;
    private final CoreNetworkChangeValues previousValues;
    private final CoreNetworkChangeValues newValues;
    private final String identifierPath;

    private CoreNetworkChange(BuilderImpl builder) {
        this.type = builder.type;
        this.action = builder.action;
        this.identifier = builder.identifier;
        this.previousValues = builder.previousValues;
        this.newValues = builder.newValues;
        this.identifierPath = builder.identifierPath;
    }

    public final ChangeType type() {
        return ChangeType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final ChangeAction action() {
        return ChangeAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final CoreNetworkChangeValues previousValues() {
        return this.previousValues;
    }

    public final CoreNetworkChangeValues newValues() {
        return this.newValues;
    }

    public final String identifierPath() {
        return this.identifierPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.newValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifierPath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoreNetworkChange)) {
            return false;
        }
        CoreNetworkChange other = (CoreNetworkChange)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.previousValues(), other.previousValues()) && Objects.equals(this.newValues(), other.newValues()) && Objects.equals(this.identifierPath(), other.identifierPath());
    }

    public final String toString() {
        return ToString.builder((String)"CoreNetworkChange").add("Type", (Object)this.typeAsString()).add("Action", (Object)this.actionAsString()).add("Identifier", (Object)this.identifier()).add("PreviousValues", (Object)this.previousValues()).add("NewValues", (Object)this.newValues()).add("IdentifierPath", (Object)this.identifierPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "PreviousValues": {
                return Optional.ofNullable(clazz.cast(this.previousValues()));
            }
            case "NewValues": {
                return Optional.ofNullable(clazz.cast(this.newValues()));
            }
            case "IdentifierPath": {
                return Optional.ofNullable(clazz.cast(this.identifierPath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Type", TYPE_FIELD);
        map.put("Action", ACTION_FIELD);
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("PreviousValues", PREVIOUS_VALUES_FIELD);
        map.put("NewValues", NEW_VALUES_FIELD);
        map.put("IdentifierPath", IDENTIFIER_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CoreNetworkChange, T> g) {
        return obj -> g.apply((CoreNetworkChange)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String action;
        private String identifier;
        private CoreNetworkChangeValues previousValues;
        private CoreNetworkChangeValues newValues;
        private String identifierPath;

        private BuilderImpl() {
        }

        private BuilderImpl(CoreNetworkChange model) {
            this.type(model.type);
            this.action(model.action);
            this.identifier(model.identifier);
            this.previousValues(model.previousValues);
            this.newValues(model.newValues);
            this.identifierPath(model.identifierPath);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChangeType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final CoreNetworkChangeValues.Builder getPreviousValues() {
            return this.previousValues != null ? this.previousValues.toBuilder() : null;
        }

        public final void setPreviousValues(CoreNetworkChangeValues.BuilderImpl previousValues) {
            this.previousValues = previousValues != null ? previousValues.build() : null;
        }

        @Override
        public final Builder previousValues(CoreNetworkChangeValues previousValues) {
            this.previousValues = previousValues;
            return this;
        }

        public final CoreNetworkChangeValues.Builder getNewValues() {
            return this.newValues != null ? this.newValues.toBuilder() : null;
        }

        public final void setNewValues(CoreNetworkChangeValues.BuilderImpl newValues) {
            this.newValues = newValues != null ? newValues.build() : null;
        }

        @Override
        public final Builder newValues(CoreNetworkChangeValues newValues) {
            this.newValues = newValues;
            return this;
        }

        public final String getIdentifierPath() {
            return this.identifierPath;
        }

        public final void setIdentifierPath(String identifierPath) {
            this.identifierPath = identifierPath;
        }

        @Override
        public final Builder identifierPath(String identifierPath) {
            this.identifierPath = identifierPath;
            return this;
        }

        public CoreNetworkChange build() {
            return new CoreNetworkChange(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CoreNetworkChange> {
        public Builder type(String var1);

        public Builder type(ChangeType var1);

        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder identifier(String var1);

        public Builder previousValues(CoreNetworkChangeValues var1);

        default public Builder previousValues(Consumer<CoreNetworkChangeValues.Builder> previousValues) {
            return this.previousValues((CoreNetworkChangeValues)((CoreNetworkChangeValues.Builder)CoreNetworkChangeValues.builder().applyMutation(previousValues)).build());
        }

        public Builder newValues(CoreNetworkChangeValues var1);

        default public Builder newValues(Consumer<CoreNetworkChangeValues.Builder> newValues) {
            return this.newValues((CoreNetworkChangeValues)((CoreNetworkChangeValues.Builder)CoreNetworkChangeValues.builder().applyMutation(newValues)).build());
        }

        public Builder identifierPath(String var1);
    }
}

