/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.RoutingPolicyAssociationDetail;
import software.amazon.awssdk.services.networkmanager.model.RoutingPolicyAssociationDetailsListCopier;
import software.amazon.awssdk.services.networkmanager.model.RoutingPolicyDirection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CoreNetworkChangeEventValues
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CoreNetworkChangeEventValues> {
    private static final SdkField<String> EDGE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EdgeLocation").getter(CoreNetworkChangeEventValues.getter(CoreNetworkChangeEventValues::edgeLocation)).setter(CoreNetworkChangeEventValues.setter(Builder::edgeLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeLocation").build()}).build();
    private static final SdkField<String> PEER_EDGE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PeerEdgeLocation").getter(CoreNetworkChangeEventValues.getter(CoreNetworkChangeEventValues::peerEdgeLocation)).setter(CoreNetworkChangeEventValues.setter(Builder::peerEdgeLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerEdgeLocation").build()}).build();
    private static final SdkField<String> ROUTING_POLICY_DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingPolicyDirection").getter(CoreNetworkChangeEventValues.getter(CoreNetworkChangeEventValues::routingPolicyDirectionAsString)).setter(CoreNetworkChangeEventValues.setter(Builder::routingPolicyDirection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingPolicyDirection").build()}).build();
    private static final SdkField<String> SEGMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentName").getter(CoreNetworkChangeEventValues.getter(CoreNetworkChangeEventValues::segmentName)).setter(CoreNetworkChangeEventValues.setter(Builder::segmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentName").build()}).build();
    private static final SdkField<String> NETWORK_FUNCTION_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkFunctionGroupName").getter(CoreNetworkChangeEventValues.getter(CoreNetworkChangeEventValues::networkFunctionGroupName)).setter(CoreNetworkChangeEventValues.setter(Builder::networkFunctionGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkFunctionGroupName").build()}).build();
    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttachmentId").getter(CoreNetworkChangeEventValues.getter(CoreNetworkChangeEventValues::attachmentId)).setter(CoreNetworkChangeEventValues.setter(Builder::attachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentId").build()}).build();
    private static final SdkField<String> CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Cidr").getter(CoreNetworkChangeEventValues.getter(CoreNetworkChangeEventValues::cidr)).setter(CoreNetworkChangeEventValues.setter(Builder::cidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr").build()}).build();
    private static final SdkField<List<RoutingPolicyAssociationDetail>> ROUTING_POLICY_ASSOCIATION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RoutingPolicyAssociationDetails").getter(CoreNetworkChangeEventValues.getter(CoreNetworkChangeEventValues::routingPolicyAssociationDetails)).setter(CoreNetworkChangeEventValues.setter(Builder::routingPolicyAssociationDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingPolicyAssociationDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RoutingPolicyAssociationDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EDGE_LOCATION_FIELD, PEER_EDGE_LOCATION_FIELD, ROUTING_POLICY_DIRECTION_FIELD, SEGMENT_NAME_FIELD, NETWORK_FUNCTION_GROUP_NAME_FIELD, ATTACHMENT_ID_FIELD, CIDR_FIELD, ROUTING_POLICY_ASSOCIATION_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CoreNetworkChangeEventValues.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String edgeLocation;
    private final String peerEdgeLocation;
    private final String routingPolicyDirection;
    private final String segmentName;
    private final String networkFunctionGroupName;
    private final String attachmentId;
    private final String cidr;
    private final List<RoutingPolicyAssociationDetail> routingPolicyAssociationDetails;

    private CoreNetworkChangeEventValues(BuilderImpl builder) {
        this.edgeLocation = builder.edgeLocation;
        this.peerEdgeLocation = builder.peerEdgeLocation;
        this.routingPolicyDirection = builder.routingPolicyDirection;
        this.segmentName = builder.segmentName;
        this.networkFunctionGroupName = builder.networkFunctionGroupName;
        this.attachmentId = builder.attachmentId;
        this.cidr = builder.cidr;
        this.routingPolicyAssociationDetails = builder.routingPolicyAssociationDetails;
    }

    public final String edgeLocation() {
        return this.edgeLocation;
    }

    public final String peerEdgeLocation() {
        return this.peerEdgeLocation;
    }

    public final RoutingPolicyDirection routingPolicyDirection() {
        return RoutingPolicyDirection.fromValue(this.routingPolicyDirection);
    }

    public final String routingPolicyDirectionAsString() {
        return this.routingPolicyDirection;
    }

    public final String segmentName() {
        return this.segmentName;
    }

    public final String networkFunctionGroupName() {
        return this.networkFunctionGroupName;
    }

    public final String attachmentId() {
        return this.attachmentId;
    }

    public final String cidr() {
        return this.cidr;
    }

    public final boolean hasRoutingPolicyAssociationDetails() {
        return this.routingPolicyAssociationDetails != null && !(this.routingPolicyAssociationDetails instanceof SdkAutoConstructList);
    }

    public final List<RoutingPolicyAssociationDetail> routingPolicyAssociationDetails() {
        return this.routingPolicyAssociationDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.edgeLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerEdgeLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingPolicyDirectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkFunctionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutingPolicyAssociationDetails() ? this.routingPolicyAssociationDetails() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoreNetworkChangeEventValues)) {
            return false;
        }
        CoreNetworkChangeEventValues other = (CoreNetworkChangeEventValues)obj;
        return Objects.equals(this.edgeLocation(), other.edgeLocation()) && Objects.equals(this.peerEdgeLocation(), other.peerEdgeLocation()) && Objects.equals(this.routingPolicyDirectionAsString(), other.routingPolicyDirectionAsString()) && Objects.equals(this.segmentName(), other.segmentName()) && Objects.equals(this.networkFunctionGroupName(), other.networkFunctionGroupName()) && Objects.equals(this.attachmentId(), other.attachmentId()) && Objects.equals(this.cidr(), other.cidr()) && this.hasRoutingPolicyAssociationDetails() == other.hasRoutingPolicyAssociationDetails() && Objects.equals(this.routingPolicyAssociationDetails(), other.routingPolicyAssociationDetails());
    }

    public final String toString() {
        return ToString.builder((String)"CoreNetworkChangeEventValues").add("EdgeLocation", (Object)this.edgeLocation()).add("PeerEdgeLocation", (Object)this.peerEdgeLocation()).add("RoutingPolicyDirection", (Object)this.routingPolicyDirectionAsString()).add("SegmentName", (Object)this.segmentName()).add("NetworkFunctionGroupName", (Object)this.networkFunctionGroupName()).add("AttachmentId", (Object)this.attachmentId()).add("Cidr", (Object)this.cidr()).add("RoutingPolicyAssociationDetails", this.hasRoutingPolicyAssociationDetails() ? this.routingPolicyAssociationDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EdgeLocation": {
                return Optional.ofNullable(clazz.cast(this.edgeLocation()));
            }
            case "PeerEdgeLocation": {
                return Optional.ofNullable(clazz.cast(this.peerEdgeLocation()));
            }
            case "RoutingPolicyDirection": {
                return Optional.ofNullable(clazz.cast(this.routingPolicyDirectionAsString()));
            }
            case "SegmentName": {
                return Optional.ofNullable(clazz.cast(this.segmentName()));
            }
            case "NetworkFunctionGroupName": {
                return Optional.ofNullable(clazz.cast(this.networkFunctionGroupName()));
            }
            case "AttachmentId": {
                return Optional.ofNullable(clazz.cast(this.attachmentId()));
            }
            case "Cidr": {
                return Optional.ofNullable(clazz.cast(this.cidr()));
            }
            case "RoutingPolicyAssociationDetails": {
                return Optional.ofNullable(clazz.cast(this.routingPolicyAssociationDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EdgeLocation", EDGE_LOCATION_FIELD);
        map.put("PeerEdgeLocation", PEER_EDGE_LOCATION_FIELD);
        map.put("RoutingPolicyDirection", ROUTING_POLICY_DIRECTION_FIELD);
        map.put("SegmentName", SEGMENT_NAME_FIELD);
        map.put("NetworkFunctionGroupName", NETWORK_FUNCTION_GROUP_NAME_FIELD);
        map.put("AttachmentId", ATTACHMENT_ID_FIELD);
        map.put("Cidr", CIDR_FIELD);
        map.put("RoutingPolicyAssociationDetails", ROUTING_POLICY_ASSOCIATION_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CoreNetworkChangeEventValues, T> g) {
        return obj -> g.apply((CoreNetworkChangeEventValues)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String edgeLocation;
        private String peerEdgeLocation;
        private String routingPolicyDirection;
        private String segmentName;
        private String networkFunctionGroupName;
        private String attachmentId;
        private String cidr;
        private List<RoutingPolicyAssociationDetail> routingPolicyAssociationDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CoreNetworkChangeEventValues model) {
            this.edgeLocation(model.edgeLocation);
            this.peerEdgeLocation(model.peerEdgeLocation);
            this.routingPolicyDirection(model.routingPolicyDirection);
            this.segmentName(model.segmentName);
            this.networkFunctionGroupName(model.networkFunctionGroupName);
            this.attachmentId(model.attachmentId);
            this.cidr(model.cidr);
            this.routingPolicyAssociationDetails(model.routingPolicyAssociationDetails);
        }

        public final String getEdgeLocation() {
            return this.edgeLocation;
        }

        public final void setEdgeLocation(String edgeLocation) {
            this.edgeLocation = edgeLocation;
        }

        @Override
        public final Builder edgeLocation(String edgeLocation) {
            this.edgeLocation = edgeLocation;
            return this;
        }

        public final String getPeerEdgeLocation() {
            return this.peerEdgeLocation;
        }

        public final void setPeerEdgeLocation(String peerEdgeLocation) {
            this.peerEdgeLocation = peerEdgeLocation;
        }

        @Override
        public final Builder peerEdgeLocation(String peerEdgeLocation) {
            this.peerEdgeLocation = peerEdgeLocation;
            return this;
        }

        public final String getRoutingPolicyDirection() {
            return this.routingPolicyDirection;
        }

        public final void setRoutingPolicyDirection(String routingPolicyDirection) {
            this.routingPolicyDirection = routingPolicyDirection;
        }

        @Override
        public final Builder routingPolicyDirection(String routingPolicyDirection) {
            this.routingPolicyDirection = routingPolicyDirection;
            return this;
        }

        @Override
        public final Builder routingPolicyDirection(RoutingPolicyDirection routingPolicyDirection) {
            this.routingPolicyDirection(routingPolicyDirection == null ? null : routingPolicyDirection.toString());
            return this;
        }

        public final String getSegmentName() {
            return this.segmentName;
        }

        public final void setSegmentName(String segmentName) {
            this.segmentName = segmentName;
        }

        @Override
        public final Builder segmentName(String segmentName) {
            this.segmentName = segmentName;
            return this;
        }

        public final String getNetworkFunctionGroupName() {
            return this.networkFunctionGroupName;
        }

        public final void setNetworkFunctionGroupName(String networkFunctionGroupName) {
            this.networkFunctionGroupName = networkFunctionGroupName;
        }

        @Override
        public final Builder networkFunctionGroupName(String networkFunctionGroupName) {
            this.networkFunctionGroupName = networkFunctionGroupName;
            return this;
        }

        public final String getAttachmentId() {
            return this.attachmentId;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final String getCidr() {
            return this.cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final List<RoutingPolicyAssociationDetail.Builder> getRoutingPolicyAssociationDetails() {
            List<RoutingPolicyAssociationDetail.Builder> result = RoutingPolicyAssociationDetailsListCopier.copyToBuilder(this.routingPolicyAssociationDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutingPolicyAssociationDetails(Collection<RoutingPolicyAssociationDetail.BuilderImpl> routingPolicyAssociationDetails) {
            this.routingPolicyAssociationDetails = RoutingPolicyAssociationDetailsListCopier.copyFromBuilder(routingPolicyAssociationDetails);
        }

        @Override
        public final Builder routingPolicyAssociationDetails(Collection<RoutingPolicyAssociationDetail> routingPolicyAssociationDetails) {
            this.routingPolicyAssociationDetails = RoutingPolicyAssociationDetailsListCopier.copy(routingPolicyAssociationDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingPolicyAssociationDetails(RoutingPolicyAssociationDetail ... routingPolicyAssociationDetails) {
            this.routingPolicyAssociationDetails(Arrays.asList(routingPolicyAssociationDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingPolicyAssociationDetails(Consumer<RoutingPolicyAssociationDetail.Builder> ... routingPolicyAssociationDetails) {
            this.routingPolicyAssociationDetails(Stream.of(routingPolicyAssociationDetails).map(c -> (RoutingPolicyAssociationDetail)((RoutingPolicyAssociationDetail.Builder)RoutingPolicyAssociationDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CoreNetworkChangeEventValues build() {
            return new CoreNetworkChangeEventValues(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CoreNetworkChangeEventValues> {
        public Builder edgeLocation(String var1);

        public Builder peerEdgeLocation(String var1);

        public Builder routingPolicyDirection(String var1);

        public Builder routingPolicyDirection(RoutingPolicyDirection var1);

        public Builder segmentName(String var1);

        public Builder networkFunctionGroupName(String var1);

        public Builder attachmentId(String var1);

        public Builder cidr(String var1);

        public Builder routingPolicyAssociationDetails(Collection<RoutingPolicyAssociationDetail> var1);

        public Builder routingPolicyAssociationDetails(RoutingPolicyAssociationDetail ... var1);

        public Builder routingPolicyAssociationDetails(Consumer<RoutingPolicyAssociationDetail.Builder> ... var1);
    }
}

