/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerClient;
import software.amazon.awssdk.services.networkmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkmanager.model.CoreNetworkRoutingInformation;
import software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkRoutingInformationRequest;
import software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkRoutingInformationResponse;

public class ListCoreNetworkRoutingInformationIterable
implements SdkIterable<ListCoreNetworkRoutingInformationResponse> {
    private final NetworkManagerClient client;
    private final ListCoreNetworkRoutingInformationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCoreNetworkRoutingInformationIterable(NetworkManagerClient client, ListCoreNetworkRoutingInformationRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCoreNetworkRoutingInformationResponseFetcher();
    }

    public Iterator<ListCoreNetworkRoutingInformationResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CoreNetworkRoutingInformation> coreNetworkRoutingInformation() {
        Function<ListCoreNetworkRoutingInformationResponse, Iterator> getIterator = response -> {
            if (response != null && response.coreNetworkRoutingInformation() != null) {
                return response.coreNetworkRoutingInformation().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCoreNetworkRoutingInformationResponseFetcher
    implements SyncPageFetcher<ListCoreNetworkRoutingInformationResponse> {
        private ListCoreNetworkRoutingInformationResponseFetcher() {
        }

        public boolean hasNextPage(ListCoreNetworkRoutingInformationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCoreNetworkRoutingInformationResponse nextPage(ListCoreNetworkRoutingInformationResponse previousPage) {
            if (previousPage == null) {
                return ListCoreNetworkRoutingInformationIterable.this.client.listCoreNetworkRoutingInformation(ListCoreNetworkRoutingInformationIterable.this.firstRequest);
            }
            return ListCoreNetworkRoutingInformationIterable.this.client.listCoreNetworkRoutingInformation((ListCoreNetworkRoutingInformationRequest)((Object)ListCoreNetworkRoutingInformationIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

