/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.ConstrainedStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RoutingPolicyAssociationDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RoutingPolicyAssociationDetail> {
    private static final SdkField<List<String>> ROUTING_POLICY_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RoutingPolicyNames").getter(RoutingPolicyAssociationDetail.getter(RoutingPolicyAssociationDetail::routingPolicyNames)).setter(RoutingPolicyAssociationDetail.setter(Builder::routingPolicyNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingPolicyNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SHARED_SEGMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SharedSegments").getter(RoutingPolicyAssociationDetail.getter(RoutingPolicyAssociationDetail::sharedSegments)).setter(RoutingPolicyAssociationDetail.setter(Builder::sharedSegments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedSegments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTING_POLICY_NAMES_FIELD, SHARED_SEGMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RoutingPolicyAssociationDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> routingPolicyNames;
    private final List<String> sharedSegments;

    private RoutingPolicyAssociationDetail(BuilderImpl builder) {
        this.routingPolicyNames = builder.routingPolicyNames;
        this.sharedSegments = builder.sharedSegments;
    }

    public final boolean hasRoutingPolicyNames() {
        return this.routingPolicyNames != null && !(this.routingPolicyNames instanceof SdkAutoConstructList);
    }

    public final List<String> routingPolicyNames() {
        return this.routingPolicyNames;
    }

    public final boolean hasSharedSegments() {
        return this.sharedSegments != null && !(this.sharedSegments instanceof SdkAutoConstructList);
    }

    public final List<String> sharedSegments() {
        return this.sharedSegments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutingPolicyNames() ? this.routingPolicyNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSharedSegments() ? this.sharedSegments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutingPolicyAssociationDetail)) {
            return false;
        }
        RoutingPolicyAssociationDetail other = (RoutingPolicyAssociationDetail)obj;
        return this.hasRoutingPolicyNames() == other.hasRoutingPolicyNames() && Objects.equals(this.routingPolicyNames(), other.routingPolicyNames()) && this.hasSharedSegments() == other.hasSharedSegments() && Objects.equals(this.sharedSegments(), other.sharedSegments());
    }

    public final String toString() {
        return ToString.builder((String)"RoutingPolicyAssociationDetail").add("RoutingPolicyNames", this.hasRoutingPolicyNames() ? this.routingPolicyNames() : null).add("SharedSegments", this.hasSharedSegments() ? this.sharedSegments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoutingPolicyNames": {
                return Optional.ofNullable(clazz.cast(this.routingPolicyNames()));
            }
            case "SharedSegments": {
                return Optional.ofNullable(clazz.cast(this.sharedSegments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("RoutingPolicyNames", ROUTING_POLICY_NAMES_FIELD);
        map.put("SharedSegments", SHARED_SEGMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoutingPolicyAssociationDetail, T> g) {
        return obj -> g.apply((RoutingPolicyAssociationDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> routingPolicyNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> sharedSegments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RoutingPolicyAssociationDetail model) {
            this.routingPolicyNames(model.routingPolicyNames);
            this.sharedSegments(model.sharedSegments);
        }

        public final Collection<String> getRoutingPolicyNames() {
            if (this.routingPolicyNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.routingPolicyNames;
        }

        public final void setRoutingPolicyNames(Collection<String> routingPolicyNames) {
            this.routingPolicyNames = ConstrainedStringListCopier.copy(routingPolicyNames);
        }

        @Override
        public final Builder routingPolicyNames(Collection<String> routingPolicyNames) {
            this.routingPolicyNames = ConstrainedStringListCopier.copy(routingPolicyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingPolicyNames(String ... routingPolicyNames) {
            this.routingPolicyNames(Arrays.asList(routingPolicyNames));
            return this;
        }

        public final Collection<String> getSharedSegments() {
            if (this.sharedSegments instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sharedSegments;
        }

        public final void setSharedSegments(Collection<String> sharedSegments) {
            this.sharedSegments = ConstrainedStringListCopier.copy(sharedSegments);
        }

        @Override
        public final Builder sharedSegments(Collection<String> sharedSegments) {
            this.sharedSegments = ConstrainedStringListCopier.copy(sharedSegments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sharedSegments(String ... sharedSegments) {
            this.sharedSegments(Arrays.asList(sharedSegments));
            return this;
        }

        public RoutingPolicyAssociationDetail build() {
            return new RoutingPolicyAssociationDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RoutingPolicyAssociationDetail> {
        public Builder routingPolicyNames(Collection<String> var1);

        public Builder routingPolicyNames(String ... var1);

        public Builder sharedSegments(Collection<String> var1);

        public Builder sharedSegments(String ... var1);
    }
}

