/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.notifications.model.MemberAccountNotificationConfigurationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MemberAccount
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MemberAccount> {
    private static final SdkField<String> NOTIFICATION_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("notificationConfigurationArn").getter(MemberAccount.getter(MemberAccount::notificationConfigurationArn)).setter(MemberAccount.setter(Builder::notificationConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationConfigurationArn").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(MemberAccount.getter(MemberAccount::accountId)).setter(MemberAccount.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(MemberAccount.getter(MemberAccount::statusAsString)).setter(MemberAccount.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(MemberAccount.getter(MemberAccount::statusReason)).setter(MemberAccount.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<String> ORGANIZATIONAL_UNIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("organizationalUnitId").getter(MemberAccount.getter(MemberAccount::organizationalUnitId)).setter(MemberAccount.setter(Builder::organizationalUnitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationalUnitId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTIFICATION_CONFIGURATION_ARN_FIELD, ACCOUNT_ID_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, ORGANIZATIONAL_UNIT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MemberAccount.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String notificationConfigurationArn;
    private final String accountId;
    private final String status;
    private final String statusReason;
    private final String organizationalUnitId;

    private MemberAccount(BuilderImpl builder) {
        this.notificationConfigurationArn = builder.notificationConfigurationArn;
        this.accountId = builder.accountId;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.organizationalUnitId = builder.organizationalUnitId;
    }

    public final String notificationConfigurationArn() {
        return this.notificationConfigurationArn;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final MemberAccountNotificationConfigurationStatus status() {
        return MemberAccountNotificationConfigurationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final String organizationalUnitId() {
        return this.organizationalUnitId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationalUnitId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemberAccount)) {
            return false;
        }
        MemberAccount other = (MemberAccount)obj;
        return Objects.equals(this.notificationConfigurationArn(), other.notificationConfigurationArn()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.organizationalUnitId(), other.organizationalUnitId());
    }

    public final String toString() {
        return ToString.builder((String)"MemberAccount").add("NotificationConfigurationArn", (Object)this.notificationConfigurationArn()).add("AccountId", (Object)this.accountId()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("OrganizationalUnitId", (Object)this.organizationalUnitId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "notificationConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.notificationConfigurationArn()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "organizationalUnitId": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnitId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("notificationConfigurationArn", NOTIFICATION_CONFIGURATION_ARN_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("organizationalUnitId", ORGANIZATIONAL_UNIT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MemberAccount, T> g) {
        return obj -> g.apply((MemberAccount)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String notificationConfigurationArn;
        private String accountId;
        private String status;
        private String statusReason;
        private String organizationalUnitId;

        private BuilderImpl() {
        }

        private BuilderImpl(MemberAccount model) {
            this.notificationConfigurationArn(model.notificationConfigurationArn);
            this.accountId(model.accountId);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.organizationalUnitId(model.organizationalUnitId);
        }

        public final String getNotificationConfigurationArn() {
            return this.notificationConfigurationArn;
        }

        public final void setNotificationConfigurationArn(String notificationConfigurationArn) {
            this.notificationConfigurationArn = notificationConfigurationArn;
        }

        @Override
        public final Builder notificationConfigurationArn(String notificationConfigurationArn) {
            this.notificationConfigurationArn = notificationConfigurationArn;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MemberAccountNotificationConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getOrganizationalUnitId() {
            return this.organizationalUnitId;
        }

        public final void setOrganizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
        }

        @Override
        public final Builder organizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
            return this;
        }

        public MemberAccount build() {
            return new MemberAccount(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MemberAccount> {
        public Builder notificationConfigurationArn(String var1);

        public Builder accountId(String var1);

        public Builder status(String var1);

        public Builder status(MemberAccountNotificationConfigurationStatus var1);

        public Builder statusReason(String var1);

        public Builder organizationalUnitId(String var1);
    }
}

