/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.novaact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.novaact.model.NovaActRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSessionRequest
extends NovaActRequest
implements ToCopyableBuilder<Builder, CreateSessionRequest> {
    private static final SdkField<String> WORKFLOW_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowDefinitionName").getter(CreateSessionRequest.getter(CreateSessionRequest::workflowDefinitionName)).setter(CreateSessionRequest.setter(Builder::workflowDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workflowDefinitionName").build()}).build();
    private static final SdkField<String> WORKFLOW_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowRunId").getter(CreateSessionRequest.getter(CreateSessionRequest::workflowRunId)).setter(CreateSessionRequest.setter(Builder::workflowRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workflowRunId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateSessionRequest.getter(CreateSessionRequest::clientToken)).setter(CreateSessionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_DEFINITION_NAME_FIELD, WORKFLOW_RUN_ID_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateSessionRequest.memberNameToFieldInitializer();
    private final String workflowDefinitionName;
    private final String workflowRunId;
    private final String clientToken;

    private CreateSessionRequest(BuilderImpl builder) {
        super(builder);
        this.workflowDefinitionName = builder.workflowDefinitionName;
        this.workflowRunId = builder.workflowRunId;
        this.clientToken = builder.clientToken;
    }

    public final String workflowDefinitionName() {
        return this.workflowDefinitionName;
    }

    public final String workflowRunId() {
        return this.workflowRunId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSessionRequest)) {
            return false;
        }
        CreateSessionRequest other = (CreateSessionRequest)((Object)obj);
        return Objects.equals(this.workflowDefinitionName(), other.workflowDefinitionName()) && Objects.equals(this.workflowRunId(), other.workflowRunId()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSessionRequest").add("WorkflowDefinitionName", (Object)this.workflowDefinitionName()).add("WorkflowRunId", (Object)this.workflowRunId()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workflowDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.workflowDefinitionName()));
            }
            case "workflowRunId": {
                return Optional.ofNullable(clazz.cast(this.workflowRunId()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("workflowDefinitionName", WORKFLOW_DEFINITION_NAME_FIELD);
        map.put("workflowRunId", WORKFLOW_RUN_ID_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSessionRequest, T> g) {
        return obj -> g.apply((CreateSessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NovaActRequest.BuilderImpl
    implements Builder {
        private String workflowDefinitionName;
        private String workflowRunId;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSessionRequest model) {
            super(model);
            this.workflowDefinitionName(model.workflowDefinitionName);
            this.workflowRunId(model.workflowRunId);
            this.clientToken(model.clientToken);
        }

        public final String getWorkflowDefinitionName() {
            return this.workflowDefinitionName;
        }

        public final void setWorkflowDefinitionName(String workflowDefinitionName) {
            this.workflowDefinitionName = workflowDefinitionName;
        }

        @Override
        public final Builder workflowDefinitionName(String workflowDefinitionName) {
            this.workflowDefinitionName = workflowDefinitionName;
            return this;
        }

        public final String getWorkflowRunId() {
            return this.workflowRunId;
        }

        public final void setWorkflowRunId(String workflowRunId) {
            this.workflowRunId = workflowRunId;
        }

        @Override
        public final Builder workflowRunId(String workflowRunId) {
            this.workflowRunId = workflowRunId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSessionRequest build() {
            return new CreateSessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NovaActRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSessionRequest> {
        public Builder workflowDefinitionName(String var1);

        public Builder workflowRunId(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

