/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CentralizationFailureReason {
    TRUSTED_ACCESS_NOT_ENABLED("TRUSTED_ACCESS_NOT_ENABLED"),
    DESTINATION_ACCOUNT_NOT_IN_ORGANIZATION("DESTINATION_ACCOUNT_NOT_IN_ORGANIZATION"),
    INTERNAL_SERVER_ERROR("INTERNAL_SERVER_ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CentralizationFailureReason> VALUE_MAP;
    private final String value;

    private CentralizationFailureReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CentralizationFailureReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CentralizationFailureReason> knownValues() {
        EnumSet<CentralizationFailureReason> knownValues = EnumSet.allOf(CentralizationFailureReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CentralizationFailureReason.class, CentralizationFailureReason::toString);
    }
}

