/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.observabilityadmin.model.IntegrationSummariesCopier;
import software.amazon.awssdk.services.observabilityadmin.model.IntegrationSummary;
import software.amazon.awssdk.services.observabilityadmin.model.ObservabilityAdminResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListS3TableIntegrationsResponse
extends ObservabilityAdminResponse
implements ToCopyableBuilder<Builder, ListS3TableIntegrationsResponse> {
    private static final SdkField<List<IntegrationSummary>> INTEGRATION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IntegrationSummaries").getter(ListS3TableIntegrationsResponse.getter(ListS3TableIntegrationsResponse::integrationSummaries)).setter(ListS3TableIntegrationsResponse.setter(Builder::integrationSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IntegrationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListS3TableIntegrationsResponse.getter(ListS3TableIntegrationsResponse::nextToken)).setter(ListS3TableIntegrationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGRATION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListS3TableIntegrationsResponse.memberNameToFieldInitializer();
    private final List<IntegrationSummary> integrationSummaries;
    private final String nextToken;

    private ListS3TableIntegrationsResponse(BuilderImpl builder) {
        super(builder);
        this.integrationSummaries = builder.integrationSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasIntegrationSummaries() {
        return this.integrationSummaries != null && !(this.integrationSummaries instanceof SdkAutoConstructList);
    }

    public final List<IntegrationSummary> integrationSummaries() {
        return this.integrationSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIntegrationSummaries() ? this.integrationSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListS3TableIntegrationsResponse)) {
            return false;
        }
        ListS3TableIntegrationsResponse other = (ListS3TableIntegrationsResponse)((Object)obj);
        return this.hasIntegrationSummaries() == other.hasIntegrationSummaries() && Objects.equals(this.integrationSummaries(), other.integrationSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListS3TableIntegrationsResponse").add("IntegrationSummaries", this.hasIntegrationSummaries() ? this.integrationSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IntegrationSummaries": {
                return Optional.ofNullable(clazz.cast(this.integrationSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IntegrationSummaries", INTEGRATION_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListS3TableIntegrationsResponse, T> g) {
        return obj -> g.apply((ListS3TableIntegrationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ObservabilityAdminResponse.BuilderImpl
    implements Builder {
        private List<IntegrationSummary> integrationSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListS3TableIntegrationsResponse model) {
            super(model);
            this.integrationSummaries(model.integrationSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<IntegrationSummary.Builder> getIntegrationSummaries() {
            List<IntegrationSummary.Builder> result = IntegrationSummariesCopier.copyToBuilder(this.integrationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIntegrationSummaries(Collection<IntegrationSummary.BuilderImpl> integrationSummaries) {
            this.integrationSummaries = IntegrationSummariesCopier.copyFromBuilder(integrationSummaries);
        }

        @Override
        public final Builder integrationSummaries(Collection<IntegrationSummary> integrationSummaries) {
            this.integrationSummaries = IntegrationSummariesCopier.copy(integrationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integrationSummaries(IntegrationSummary ... integrationSummaries) {
            this.integrationSummaries(Arrays.asList(integrationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integrationSummaries(Consumer<IntegrationSummary.Builder> ... integrationSummaries) {
            this.integrationSummaries(Stream.of(integrationSummaries).map(c -> (IntegrationSummary)((IntegrationSummary.Builder)IntegrationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListS3TableIntegrationsResponse build() {
            return new ListS3TableIntegrationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ObservabilityAdminResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListS3TableIntegrationsResponse> {
        public Builder integrationSummaries(Collection<IntegrationSummary> var1);

        public Builder integrationSummaries(IntegrationSummary ... var1);

        public Builder integrationSummaries(Consumer<IntegrationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

