/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VPCFlowLogParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VPCFlowLogParameters> {
    private static final SdkField<String> LOG_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogFormat").getter(VPCFlowLogParameters.getter(VPCFlowLogParameters::logFormat)).setter(VPCFlowLogParameters.setter(Builder::logFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFormat").build()}).build();
    private static final SdkField<String> TRAFFIC_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficType").getter(VPCFlowLogParameters.getter(VPCFlowLogParameters::trafficType)).setter(VPCFlowLogParameters.setter(Builder::trafficType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficType").build()}).build();
    private static final SdkField<Integer> MAX_AGGREGATION_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxAggregationInterval").getter(VPCFlowLogParameters.getter(VPCFlowLogParameters::maxAggregationInterval)).setter(VPCFlowLogParameters.setter(Builder::maxAggregationInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAggregationInterval").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_FORMAT_FIELD, TRAFFIC_TYPE_FIELD, MAX_AGGREGATION_INTERVAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VPCFlowLogParameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String logFormat;
    private final String trafficType;
    private final Integer maxAggregationInterval;

    private VPCFlowLogParameters(BuilderImpl builder) {
        this.logFormat = builder.logFormat;
        this.trafficType = builder.trafficType;
        this.maxAggregationInterval = builder.maxAggregationInterval;
    }

    public final String logFormat() {
        return this.logFormat;
    }

    public final String trafficType() {
        return this.trafficType;
    }

    public final Integer maxAggregationInterval() {
        return this.maxAggregationInterval;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficType());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAggregationInterval());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VPCFlowLogParameters)) {
            return false;
        }
        VPCFlowLogParameters other = (VPCFlowLogParameters)obj;
        return Objects.equals(this.logFormat(), other.logFormat()) && Objects.equals(this.trafficType(), other.trafficType()) && Objects.equals(this.maxAggregationInterval(), other.maxAggregationInterval());
    }

    public final String toString() {
        return ToString.builder((String)"VPCFlowLogParameters").add("LogFormat", (Object)this.logFormat()).add("TrafficType", (Object)this.trafficType()).add("MaxAggregationInterval", (Object)this.maxAggregationInterval()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogFormat": {
                return Optional.ofNullable(clazz.cast(this.logFormat()));
            }
            case "TrafficType": {
                return Optional.ofNullable(clazz.cast(this.trafficType()));
            }
            case "MaxAggregationInterval": {
                return Optional.ofNullable(clazz.cast(this.maxAggregationInterval()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LogFormat", LOG_FORMAT_FIELD);
        map.put("TrafficType", TRAFFIC_TYPE_FIELD);
        map.put("MaxAggregationInterval", MAX_AGGREGATION_INTERVAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VPCFlowLogParameters, T> g) {
        return obj -> g.apply((VPCFlowLogParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logFormat;
        private String trafficType;
        private Integer maxAggregationInterval;

        private BuilderImpl() {
        }

        private BuilderImpl(VPCFlowLogParameters model) {
            this.logFormat(model.logFormat);
            this.trafficType(model.trafficType);
            this.maxAggregationInterval(model.maxAggregationInterval);
        }

        public final String getLogFormat() {
            return this.logFormat;
        }

        public final void setLogFormat(String logFormat) {
            this.logFormat = logFormat;
        }

        @Override
        public final Builder logFormat(String logFormat) {
            this.logFormat = logFormat;
            return this;
        }

        public final String getTrafficType() {
            return this.trafficType;
        }

        public final void setTrafficType(String trafficType) {
            this.trafficType = trafficType;
        }

        @Override
        public final Builder trafficType(String trafficType) {
            this.trafficType = trafficType;
            return this;
        }

        public final Integer getMaxAggregationInterval() {
            return this.maxAggregationInterval;
        }

        public final void setMaxAggregationInterval(Integer maxAggregationInterval) {
            this.maxAggregationInterval = maxAggregationInterval;
        }

        @Override
        public final Builder maxAggregationInterval(Integer maxAggregationInterval) {
            this.maxAggregationInterval = maxAggregationInterval;
            return this;
        }

        public VPCFlowLogParameters build() {
            return new VPCFlowLogParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VPCFlowLogParameters> {
        public Builder logFormat(String var1);

        public Builder trafficType(String var1);

        public Builder maxAggregationInterval(Integer var1);
    }
}

