/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.observabilityadmin.model.AccountIdentifiersCopier;
import software.amazon.awssdk.services.observabilityadmin.model.ObservabilityAdminRequest;
import software.amazon.awssdk.services.observabilityadmin.model.OrganizationUnitIdentifiersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTelemetryRulesForOrganizationRequest
extends ObservabilityAdminRequest
implements ToCopyableBuilder<Builder, ListTelemetryRulesForOrganizationRequest> {
    private static final SdkField<String> RULE_NAME_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleNamePrefix").getter(ListTelemetryRulesForOrganizationRequest.getter(ListTelemetryRulesForOrganizationRequest::ruleNamePrefix)).setter(ListTelemetryRulesForOrganizationRequest.setter(Builder::ruleNamePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleNamePrefix").build()}).build();
    private static final SdkField<List<String>> SOURCE_ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourceAccountIds").getter(ListTelemetryRulesForOrganizationRequest.getter(ListTelemetryRulesForOrganizationRequest::sourceAccountIds)).setter(ListTelemetryRulesForOrganizationRequest.setter(Builder::sourceAccountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAccountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SOURCE_ORGANIZATION_UNIT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourceOrganizationUnitIds").getter(ListTelemetryRulesForOrganizationRequest.getter(ListTelemetryRulesForOrganizationRequest::sourceOrganizationUnitIds)).setter(ListTelemetryRulesForOrganizationRequest.setter(Builder::sourceOrganizationUnitIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceOrganizationUnitIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListTelemetryRulesForOrganizationRequest.getter(ListTelemetryRulesForOrganizationRequest::maxResults)).setter(ListTelemetryRulesForOrganizationRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTelemetryRulesForOrganizationRequest.getter(ListTelemetryRulesForOrganizationRequest::nextToken)).setter(ListTelemetryRulesForOrganizationRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_PREFIX_FIELD, SOURCE_ACCOUNT_IDS_FIELD, SOURCE_ORGANIZATION_UNIT_IDS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTelemetryRulesForOrganizationRequest.memberNameToFieldInitializer();
    private final String ruleNamePrefix;
    private final List<String> sourceAccountIds;
    private final List<String> sourceOrganizationUnitIds;
    private final Integer maxResults;
    private final String nextToken;

    private ListTelemetryRulesForOrganizationRequest(BuilderImpl builder) {
        super(builder);
        this.ruleNamePrefix = builder.ruleNamePrefix;
        this.sourceAccountIds = builder.sourceAccountIds;
        this.sourceOrganizationUnitIds = builder.sourceOrganizationUnitIds;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String ruleNamePrefix() {
        return this.ruleNamePrefix;
    }

    public final boolean hasSourceAccountIds() {
        return this.sourceAccountIds != null && !(this.sourceAccountIds instanceof SdkAutoConstructList);
    }

    public final List<String> sourceAccountIds() {
        return this.sourceAccountIds;
    }

    public final boolean hasSourceOrganizationUnitIds() {
        return this.sourceOrganizationUnitIds != null && !(this.sourceOrganizationUnitIds instanceof SdkAutoConstructList);
    }

    public final List<String> sourceOrganizationUnitIds() {
        return this.sourceOrganizationUnitIds;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceAccountIds() ? this.sourceAccountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceOrganizationUnitIds() ? this.sourceOrganizationUnitIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTelemetryRulesForOrganizationRequest)) {
            return false;
        }
        ListTelemetryRulesForOrganizationRequest other = (ListTelemetryRulesForOrganizationRequest)((Object)obj);
        return Objects.equals(this.ruleNamePrefix(), other.ruleNamePrefix()) && this.hasSourceAccountIds() == other.hasSourceAccountIds() && Objects.equals(this.sourceAccountIds(), other.sourceAccountIds()) && this.hasSourceOrganizationUnitIds() == other.hasSourceOrganizationUnitIds() && Objects.equals(this.sourceOrganizationUnitIds(), other.sourceOrganizationUnitIds()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTelemetryRulesForOrganizationRequest").add("RuleNamePrefix", (Object)this.ruleNamePrefix()).add("SourceAccountIds", this.hasSourceAccountIds() ? this.sourceAccountIds() : null).add("SourceOrganizationUnitIds", this.hasSourceOrganizationUnitIds() ? this.sourceOrganizationUnitIds() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleNamePrefix": {
                return Optional.ofNullable(clazz.cast(this.ruleNamePrefix()));
            }
            case "SourceAccountIds": {
                return Optional.ofNullable(clazz.cast(this.sourceAccountIds()));
            }
            case "SourceOrganizationUnitIds": {
                return Optional.ofNullable(clazz.cast(this.sourceOrganizationUnitIds()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RuleNamePrefix", RULE_NAME_PREFIX_FIELD);
        map.put("SourceAccountIds", SOURCE_ACCOUNT_IDS_FIELD);
        map.put("SourceOrganizationUnitIds", SOURCE_ORGANIZATION_UNIT_IDS_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTelemetryRulesForOrganizationRequest, T> g) {
        return obj -> g.apply((ListTelemetryRulesForOrganizationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ObservabilityAdminRequest.BuilderImpl
    implements Builder {
        private String ruleNamePrefix;
        private List<String> sourceAccountIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> sourceOrganizationUnitIds = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTelemetryRulesForOrganizationRequest model) {
            super(model);
            this.ruleNamePrefix(model.ruleNamePrefix);
            this.sourceAccountIds(model.sourceAccountIds);
            this.sourceOrganizationUnitIds(model.sourceOrganizationUnitIds);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getRuleNamePrefix() {
            return this.ruleNamePrefix;
        }

        public final void setRuleNamePrefix(String ruleNamePrefix) {
            this.ruleNamePrefix = ruleNamePrefix;
        }

        @Override
        public final Builder ruleNamePrefix(String ruleNamePrefix) {
            this.ruleNamePrefix = ruleNamePrefix;
            return this;
        }

        public final Collection<String> getSourceAccountIds() {
            if (this.sourceAccountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sourceAccountIds;
        }

        public final void setSourceAccountIds(Collection<String> sourceAccountIds) {
            this.sourceAccountIds = AccountIdentifiersCopier.copy(sourceAccountIds);
        }

        @Override
        public final Builder sourceAccountIds(Collection<String> sourceAccountIds) {
            this.sourceAccountIds = AccountIdentifiersCopier.copy(sourceAccountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAccountIds(String ... sourceAccountIds) {
            this.sourceAccountIds(Arrays.asList(sourceAccountIds));
            return this;
        }

        public final Collection<String> getSourceOrganizationUnitIds() {
            if (this.sourceOrganizationUnitIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sourceOrganizationUnitIds;
        }

        public final void setSourceOrganizationUnitIds(Collection<String> sourceOrganizationUnitIds) {
            this.sourceOrganizationUnitIds = OrganizationUnitIdentifiersCopier.copy(sourceOrganizationUnitIds);
        }

        @Override
        public final Builder sourceOrganizationUnitIds(Collection<String> sourceOrganizationUnitIds) {
            this.sourceOrganizationUnitIds = OrganizationUnitIdentifiersCopier.copy(sourceOrganizationUnitIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceOrganizationUnitIds(String ... sourceOrganizationUnitIds) {
            this.sourceOrganizationUnitIds(Arrays.asList(sourceOrganizationUnitIds));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTelemetryRulesForOrganizationRequest build() {
            return new ListTelemetryRulesForOrganizationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ObservabilityAdminRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTelemetryRulesForOrganizationRequest> {
        public Builder ruleNamePrefix(String var1);

        public Builder sourceAccountIds(Collection<String> var1);

        public Builder sourceAccountIds(String ... var1);

        public Builder sourceOrganizationUnitIds(Collection<String> var1);

        public Builder sourceOrganizationUnitIds(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

