/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.observabilityadmin.ObservabilityAdminClient;
import software.amazon.awssdk.services.observabilityadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryPipelinesRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryPipelinesResponse;
import software.amazon.awssdk.services.observabilityadmin.model.TelemetryPipelineSummary;

public class ListTelemetryPipelinesIterable
implements SdkIterable<ListTelemetryPipelinesResponse> {
    private final ObservabilityAdminClient client;
    private final ListTelemetryPipelinesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTelemetryPipelinesIterable(ObservabilityAdminClient client, ListTelemetryPipelinesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTelemetryPipelinesResponseFetcher();
    }

    public Iterator<ListTelemetryPipelinesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TelemetryPipelineSummary> pipelineSummaries() {
        Function<ListTelemetryPipelinesResponse, Iterator> getIterator = response -> {
            if (response != null && response.pipelineSummaries() != null) {
                return response.pipelineSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTelemetryPipelinesResponseFetcher
    implements SyncPageFetcher<ListTelemetryPipelinesResponse> {
        private ListTelemetryPipelinesResponseFetcher() {
        }

        public boolean hasNextPage(ListTelemetryPipelinesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTelemetryPipelinesResponse nextPage(ListTelemetryPipelinesResponse previousPage) {
            if (previousPage == null) {
                return ListTelemetryPipelinesIterable.this.client.listTelemetryPipelines(ListTelemetryPipelinesIterable.this.firstRequest);
            }
            return ListTelemetryPipelinesIterable.this.client.listTelemetryPipelines((ListTelemetryPipelinesRequest)((Object)ListTelemetryPipelinesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

