/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.odb.OdbAsyncClient;
import software.amazon.awssdk.services.odb.internal.UserAgentUtils;
import software.amazon.awssdk.services.odb.model.GiVersionSummary;
import software.amazon.awssdk.services.odb.model.ListGiVersionsRequest;
import software.amazon.awssdk.services.odb.model.ListGiVersionsResponse;

public class ListGiVersionsPublisher
implements SdkPublisher<ListGiVersionsResponse> {
    private final OdbAsyncClient client;
    private final ListGiVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGiVersionsPublisher(OdbAsyncClient client, ListGiVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGiVersionsPublisher(OdbAsyncClient client, ListGiVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGiVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGiVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GiVersionSummary> giVersions() {
        Function<ListGiVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.giVersions() != null) {
                return response.giVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListGiVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListGiVersionsResponseFetcher
    implements AsyncPageFetcher<ListGiVersionsResponse> {
        private ListGiVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListGiVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListGiVersionsResponse> nextPage(ListGiVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListGiVersionsPublisher.this.client.listGiVersions(ListGiVersionsPublisher.this.firstRequest);
            }
            return ListGiVersionsPublisher.this.client.listGiVersions((ListGiVersionsRequest)((Object)ListGiVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

