/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.omics.model.ExportReadSetJobDetail;
import software.amazon.awssdk.services.omics.model.ExportReadSetJobDetailListCopier;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListReadSetExportJobsResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, ListReadSetExportJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListReadSetExportJobsResponse.getter(ListReadSetExportJobsResponse::nextToken)).setter(ListReadSetExportJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ExportReadSetJobDetail>> EXPORT_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("exportJobs").getter(ListReadSetExportJobsResponse.getter(ListReadSetExportJobsResponse::exportJobs)).setter(ListReadSetExportJobsResponse.setter(Builder::exportJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExportReadSetJobDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, EXPORT_JOBS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListReadSetExportJobsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ExportReadSetJobDetail> exportJobs;

    private ListReadSetExportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.exportJobs = builder.exportJobs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasExportJobs() {
        return this.exportJobs != null && !(this.exportJobs instanceof SdkAutoConstructList);
    }

    public final List<ExportReadSetJobDetail> exportJobs() {
        return this.exportJobs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExportJobs() ? this.exportJobs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReadSetExportJobsResponse)) {
            return false;
        }
        ListReadSetExportJobsResponse other = (ListReadSetExportJobsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasExportJobs() == other.hasExportJobs() && Objects.equals(this.exportJobs(), other.exportJobs());
    }

    public final String toString() {
        return ToString.builder((String)"ListReadSetExportJobsResponse").add("NextToken", (Object)this.nextToken()).add("ExportJobs", this.hasExportJobs() ? this.exportJobs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "exportJobs": {
                return Optional.ofNullable(clazz.cast(this.exportJobs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("exportJobs", EXPORT_JOBS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListReadSetExportJobsResponse, T> g) {
        return obj -> g.apply((ListReadSetExportJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ExportReadSetJobDetail> exportJobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListReadSetExportJobsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.exportJobs(model.exportJobs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ExportReadSetJobDetail.Builder> getExportJobs() {
            List<ExportReadSetJobDetail.Builder> result = ExportReadSetJobDetailListCopier.copyToBuilder(this.exportJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExportJobs(Collection<ExportReadSetJobDetail.BuilderImpl> exportJobs) {
            this.exportJobs = ExportReadSetJobDetailListCopier.copyFromBuilder(exportJobs);
        }

        @Override
        public final Builder exportJobs(Collection<ExportReadSetJobDetail> exportJobs) {
            this.exportJobs = ExportReadSetJobDetailListCopier.copy(exportJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportJobs(ExportReadSetJobDetail ... exportJobs) {
            this.exportJobs(Arrays.asList(exportJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportJobs(Consumer<ExportReadSetJobDetail.Builder> ... exportJobs) {
            this.exportJobs(Stream.of(exportJobs).map(c -> (ExportReadSetJobDetail)((ExportReadSetJobDetail.Builder)ExportReadSetJobDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListReadSetExportJobsResponse build() {
            return new ListReadSetExportJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListReadSetExportJobsResponse> {
        public Builder nextToken(String var1);

        public Builder exportJobs(Collection<ExportReadSetJobDetail> var1);

        public Builder exportJobs(ExportReadSetJobDetail ... var1);

        public Builder exportJobs(Consumer<ExportReadSetJobDetail.Builder> ... var1);
    }
}

