/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.RequirementLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PackageConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PackageConfiguration> {
    private static final SdkField<String> LICENSE_REQUIREMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseRequirement").getter(PackageConfiguration.getter(PackageConfiguration::licenseRequirementAsString)).setter(PackageConfiguration.setter(Builder::licenseRequirement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseRequirement").build()}).build();
    private static final SdkField<String> LICENSE_FILEPATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseFilepath").getter(PackageConfiguration.getter(PackageConfiguration::licenseFilepath)).setter(PackageConfiguration.setter(Builder::licenseFilepath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseFilepath").build()}).build();
    private static final SdkField<String> CONFIGURATION_REQUIREMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationRequirement").getter(PackageConfiguration.getter(PackageConfiguration::configurationRequirementAsString)).setter(PackageConfiguration.setter(Builder::configurationRequirement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationRequirement").build()}).build();
    private static final SdkField<Boolean> REQUIRES_RESTART_FOR_CONFIGURATION_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RequiresRestartForConfigurationUpdate").getter(PackageConfiguration.getter(PackageConfiguration::requiresRestartForConfigurationUpdate)).setter(PackageConfiguration.setter(Builder::requiresRestartForConfigurationUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequiresRestartForConfigurationUpdate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_REQUIREMENT_FIELD, LICENSE_FILEPATH_FIELD, CONFIGURATION_REQUIREMENT_FIELD, REQUIRES_RESTART_FOR_CONFIGURATION_UPDATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PackageConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String licenseRequirement;
    private final String licenseFilepath;
    private final String configurationRequirement;
    private final Boolean requiresRestartForConfigurationUpdate;

    private PackageConfiguration(BuilderImpl builder) {
        this.licenseRequirement = builder.licenseRequirement;
        this.licenseFilepath = builder.licenseFilepath;
        this.configurationRequirement = builder.configurationRequirement;
        this.requiresRestartForConfigurationUpdate = builder.requiresRestartForConfigurationUpdate;
    }

    public final RequirementLevel licenseRequirement() {
        return RequirementLevel.fromValue(this.licenseRequirement);
    }

    public final String licenseRequirementAsString() {
        return this.licenseRequirement;
    }

    public final String licenseFilepath() {
        return this.licenseFilepath;
    }

    public final RequirementLevel configurationRequirement() {
        return RequirementLevel.fromValue(this.configurationRequirement);
    }

    public final String configurationRequirementAsString() {
        return this.configurationRequirement;
    }

    public final Boolean requiresRestartForConfigurationUpdate() {
        return this.requiresRestartForConfigurationUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseRequirementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseFilepath());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationRequirementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.requiresRestartForConfigurationUpdate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageConfiguration)) {
            return false;
        }
        PackageConfiguration other = (PackageConfiguration)obj;
        return Objects.equals(this.licenseRequirementAsString(), other.licenseRequirementAsString()) && Objects.equals(this.licenseFilepath(), other.licenseFilepath()) && Objects.equals(this.configurationRequirementAsString(), other.configurationRequirementAsString()) && Objects.equals(this.requiresRestartForConfigurationUpdate(), other.requiresRestartForConfigurationUpdate());
    }

    public final String toString() {
        return ToString.builder((String)"PackageConfiguration").add("LicenseRequirement", (Object)this.licenseRequirementAsString()).add("LicenseFilepath", (Object)this.licenseFilepath()).add("ConfigurationRequirement", (Object)this.configurationRequirementAsString()).add("RequiresRestartForConfigurationUpdate", (Object)this.requiresRestartForConfigurationUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LicenseRequirement": {
                return Optional.ofNullable(clazz.cast(this.licenseRequirementAsString()));
            }
            case "LicenseFilepath": {
                return Optional.ofNullable(clazz.cast(this.licenseFilepath()));
            }
            case "ConfigurationRequirement": {
                return Optional.ofNullable(clazz.cast(this.configurationRequirementAsString()));
            }
            case "RequiresRestartForConfigurationUpdate": {
                return Optional.ofNullable(clazz.cast(this.requiresRestartForConfigurationUpdate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LicenseRequirement", LICENSE_REQUIREMENT_FIELD);
        map.put("LicenseFilepath", LICENSE_FILEPATH_FIELD);
        map.put("ConfigurationRequirement", CONFIGURATION_REQUIREMENT_FIELD);
        map.put("RequiresRestartForConfigurationUpdate", REQUIRES_RESTART_FOR_CONFIGURATION_UPDATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PackageConfiguration, T> g) {
        return obj -> g.apply((PackageConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String licenseRequirement;
        private String licenseFilepath;
        private String configurationRequirement;
        private Boolean requiresRestartForConfigurationUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageConfiguration model) {
            this.licenseRequirement(model.licenseRequirement);
            this.licenseFilepath(model.licenseFilepath);
            this.configurationRequirement(model.configurationRequirement);
            this.requiresRestartForConfigurationUpdate(model.requiresRestartForConfigurationUpdate);
        }

        public final String getLicenseRequirement() {
            return this.licenseRequirement;
        }

        public final void setLicenseRequirement(String licenseRequirement) {
            this.licenseRequirement = licenseRequirement;
        }

        @Override
        public final Builder licenseRequirement(String licenseRequirement) {
            this.licenseRequirement = licenseRequirement;
            return this;
        }

        @Override
        public final Builder licenseRequirement(RequirementLevel licenseRequirement) {
            this.licenseRequirement(licenseRequirement == null ? null : licenseRequirement.toString());
            return this;
        }

        public final String getLicenseFilepath() {
            return this.licenseFilepath;
        }

        public final void setLicenseFilepath(String licenseFilepath) {
            this.licenseFilepath = licenseFilepath;
        }

        @Override
        public final Builder licenseFilepath(String licenseFilepath) {
            this.licenseFilepath = licenseFilepath;
            return this;
        }

        public final String getConfigurationRequirement() {
            return this.configurationRequirement;
        }

        public final void setConfigurationRequirement(String configurationRequirement) {
            this.configurationRequirement = configurationRequirement;
        }

        @Override
        public final Builder configurationRequirement(String configurationRequirement) {
            this.configurationRequirement = configurationRequirement;
            return this;
        }

        @Override
        public final Builder configurationRequirement(RequirementLevel configurationRequirement) {
            this.configurationRequirement(configurationRequirement == null ? null : configurationRequirement.toString());
            return this;
        }

        public final Boolean getRequiresRestartForConfigurationUpdate() {
            return this.requiresRestartForConfigurationUpdate;
        }

        public final void setRequiresRestartForConfigurationUpdate(Boolean requiresRestartForConfigurationUpdate) {
            this.requiresRestartForConfigurationUpdate = requiresRestartForConfigurationUpdate;
        }

        @Override
        public final Builder requiresRestartForConfigurationUpdate(Boolean requiresRestartForConfigurationUpdate) {
            this.requiresRestartForConfigurationUpdate = requiresRestartForConfigurationUpdate;
            return this;
        }

        public PackageConfiguration build() {
            return new PackageConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PackageConfiguration> {
        public Builder licenseRequirement(String var1);

        public Builder licenseRequirement(RequirementLevel var1);

        public Builder licenseFilepath(String var1);

        public Builder configurationRequirement(String var1);

        public Builder configurationRequirement(RequirementLevel var1);

        public Builder requiresRestartForConfigurationUpdate(Boolean var1);
    }
}

