/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.NaturalLanguageQueryGenerationOptionsOutput;
import software.amazon.awssdk.services.opensearch.model.S3VectorsEngine;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AIMLOptionsOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AIMLOptionsOutput> {
    private static final SdkField<NaturalLanguageQueryGenerationOptionsOutput> NATURAL_LANGUAGE_QUERY_GENERATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NaturalLanguageQueryGenerationOptions").getter(AIMLOptionsOutput.getter(AIMLOptionsOutput::naturalLanguageQueryGenerationOptions)).setter(AIMLOptionsOutput.setter(Builder::naturalLanguageQueryGenerationOptions)).constructor(NaturalLanguageQueryGenerationOptionsOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NaturalLanguageQueryGenerationOptions").build()}).build();
    private static final SdkField<S3VectorsEngine> S3_VECTORS_ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3VectorsEngine").getter(AIMLOptionsOutput.getter(AIMLOptionsOutput::s3VectorsEngine)).setter(AIMLOptionsOutput.setter(Builder::s3VectorsEngine)).constructor(S3VectorsEngine::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3VectorsEngine").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NATURAL_LANGUAGE_QUERY_GENERATION_OPTIONS_FIELD, S3_VECTORS_ENGINE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AIMLOptionsOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final NaturalLanguageQueryGenerationOptionsOutput naturalLanguageQueryGenerationOptions;
    private final S3VectorsEngine s3VectorsEngine;

    private AIMLOptionsOutput(BuilderImpl builder) {
        this.naturalLanguageQueryGenerationOptions = builder.naturalLanguageQueryGenerationOptions;
        this.s3VectorsEngine = builder.s3VectorsEngine;
    }

    public final NaturalLanguageQueryGenerationOptionsOutput naturalLanguageQueryGenerationOptions() {
        return this.naturalLanguageQueryGenerationOptions;
    }

    public final S3VectorsEngine s3VectorsEngine() {
        return this.s3VectorsEngine;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.naturalLanguageQueryGenerationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3VectorsEngine());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AIMLOptionsOutput)) {
            return false;
        }
        AIMLOptionsOutput other = (AIMLOptionsOutput)obj;
        return Objects.equals(this.naturalLanguageQueryGenerationOptions(), other.naturalLanguageQueryGenerationOptions()) && Objects.equals(this.s3VectorsEngine(), other.s3VectorsEngine());
    }

    public final String toString() {
        return ToString.builder((String)"AIMLOptionsOutput").add("NaturalLanguageQueryGenerationOptions", (Object)this.naturalLanguageQueryGenerationOptions()).add("S3VectorsEngine", (Object)this.s3VectorsEngine()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NaturalLanguageQueryGenerationOptions": {
                return Optional.ofNullable(clazz.cast(this.naturalLanguageQueryGenerationOptions()));
            }
            case "S3VectorsEngine": {
                return Optional.ofNullable(clazz.cast(this.s3VectorsEngine()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NaturalLanguageQueryGenerationOptions", NATURAL_LANGUAGE_QUERY_GENERATION_OPTIONS_FIELD);
        map.put("S3VectorsEngine", S3_VECTORS_ENGINE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AIMLOptionsOutput, T> g) {
        return obj -> g.apply((AIMLOptionsOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private NaturalLanguageQueryGenerationOptionsOutput naturalLanguageQueryGenerationOptions;
        private S3VectorsEngine s3VectorsEngine;

        private BuilderImpl() {
        }

        private BuilderImpl(AIMLOptionsOutput model) {
            this.naturalLanguageQueryGenerationOptions(model.naturalLanguageQueryGenerationOptions);
            this.s3VectorsEngine(model.s3VectorsEngine);
        }

        public final NaturalLanguageQueryGenerationOptionsOutput.Builder getNaturalLanguageQueryGenerationOptions() {
            return this.naturalLanguageQueryGenerationOptions != null ? this.naturalLanguageQueryGenerationOptions.toBuilder() : null;
        }

        public final void setNaturalLanguageQueryGenerationOptions(NaturalLanguageQueryGenerationOptionsOutput.BuilderImpl naturalLanguageQueryGenerationOptions) {
            this.naturalLanguageQueryGenerationOptions = naturalLanguageQueryGenerationOptions != null ? naturalLanguageQueryGenerationOptions.build() : null;
        }

        @Override
        public final Builder naturalLanguageQueryGenerationOptions(NaturalLanguageQueryGenerationOptionsOutput naturalLanguageQueryGenerationOptions) {
            this.naturalLanguageQueryGenerationOptions = naturalLanguageQueryGenerationOptions;
            return this;
        }

        public final S3VectorsEngine.Builder getS3VectorsEngine() {
            return this.s3VectorsEngine != null ? this.s3VectorsEngine.toBuilder() : null;
        }

        public final void setS3VectorsEngine(S3VectorsEngine.BuilderImpl s3VectorsEngine) {
            this.s3VectorsEngine = s3VectorsEngine != null ? s3VectorsEngine.build() : null;
        }

        @Override
        public final Builder s3VectorsEngine(S3VectorsEngine s3VectorsEngine) {
            this.s3VectorsEngine = s3VectorsEngine;
            return this;
        }

        public AIMLOptionsOutput build() {
            return new AIMLOptionsOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AIMLOptionsOutput> {
        public Builder naturalLanguageQueryGenerationOptions(NaturalLanguageQueryGenerationOptionsOutput var1);

        default public Builder naturalLanguageQueryGenerationOptions(Consumer<NaturalLanguageQueryGenerationOptionsOutput.Builder> naturalLanguageQueryGenerationOptions) {
            return this.naturalLanguageQueryGenerationOptions((NaturalLanguageQueryGenerationOptionsOutput)((NaturalLanguageQueryGenerationOptionsOutput.Builder)NaturalLanguageQueryGenerationOptionsOutput.builder().applyMutation(naturalLanguageQueryGenerationOptions)).build());
        }

        public Builder s3VectorsEngine(S3VectorsEngine var1);

        default public Builder s3VectorsEngine(Consumer<S3VectorsEngine.Builder> s3VectorsEngine) {
            return this.s3VectorsEngine((S3VectorsEngine)((S3VectorsEngine.Builder)S3VectorsEngine.builder().applyMutation(s3VectorsEngine)).build());
        }
    }
}

