/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.opensearch.model.CloudWatchDirectQueryDataSource;
import software.amazon.awssdk.services.opensearch.model.SecurityLakeDirectQueryDataSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DirectQueryDataSourceType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DirectQueryDataSourceType> {
    private static final SdkField<CloudWatchDirectQueryDataSource> CLOUD_WATCH_LOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudWatchLog").getter(DirectQueryDataSourceType.getter(DirectQueryDataSourceType::cloudWatchLog)).setter(DirectQueryDataSourceType.setter(Builder::cloudWatchLog)).constructor(CloudWatchDirectQueryDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLog").build()}).build();
    private static final SdkField<SecurityLakeDirectQueryDataSource> SECURITY_LAKE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecurityLake").getter(DirectQueryDataSourceType.getter(DirectQueryDataSourceType::securityLake)).setter(DirectQueryDataSourceType.setter(Builder::securityLake)).constructor(SecurityLakeDirectQueryDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityLake").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_LOG_FIELD, SECURITY_LAKE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DirectQueryDataSourceType.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CloudWatchDirectQueryDataSource cloudWatchLog;
    private final SecurityLakeDirectQueryDataSource securityLake;
    private final Type type;

    private DirectQueryDataSourceType(BuilderImpl builder) {
        this.cloudWatchLog = builder.cloudWatchLog;
        this.securityLake = builder.securityLake;
        this.type = builder.type;
    }

    public final CloudWatchDirectQueryDataSource cloudWatchLog() {
        return this.cloudWatchLog;
    }

    public final SecurityLakeDirectQueryDataSource securityLake() {
        return this.securityLake;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLog());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityLake());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectQueryDataSourceType)) {
            return false;
        }
        DirectQueryDataSourceType other = (DirectQueryDataSourceType)obj;
        return Objects.equals(this.cloudWatchLog(), other.cloudWatchLog()) && Objects.equals(this.securityLake(), other.securityLake());
    }

    public final String toString() {
        return ToString.builder((String)"DirectQueryDataSourceType").add("CloudWatchLog", (Object)this.cloudWatchLog()).add("SecurityLake", (Object)this.securityLake()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudWatchLog": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLog()));
            }
            case "SecurityLake": {
                return Optional.ofNullable(clazz.cast(this.securityLake()));
            }
        }
        return Optional.empty();
    }

    public static DirectQueryDataSourceType fromCloudWatchLog(CloudWatchDirectQueryDataSource cloudWatchLog) {
        return (DirectQueryDataSourceType)DirectQueryDataSourceType.builder().cloudWatchLog(cloudWatchLog).build();
    }

    public static DirectQueryDataSourceType fromCloudWatchLog(Consumer<CloudWatchDirectQueryDataSource.Builder> cloudWatchLog) {
        CloudWatchDirectQueryDataSource.Builder builder = CloudWatchDirectQueryDataSource.builder();
        cloudWatchLog.accept(builder);
        return DirectQueryDataSourceType.fromCloudWatchLog((CloudWatchDirectQueryDataSource)builder.build());
    }

    public static DirectQueryDataSourceType fromSecurityLake(SecurityLakeDirectQueryDataSource securityLake) {
        return (DirectQueryDataSourceType)DirectQueryDataSourceType.builder().securityLake(securityLake).build();
    }

    public static DirectQueryDataSourceType fromSecurityLake(Consumer<SecurityLakeDirectQueryDataSource.Builder> securityLake) {
        SecurityLakeDirectQueryDataSource.Builder builder = SecurityLakeDirectQueryDataSource.builder();
        securityLake.accept(builder);
        return DirectQueryDataSourceType.fromSecurityLake((SecurityLakeDirectQueryDataSource)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CloudWatchLog", CLOUD_WATCH_LOG_FIELD);
        map.put("SecurityLake", SECURITY_LAKE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DirectQueryDataSourceType, T> g) {
        return obj -> g.apply((DirectQueryDataSourceType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CLOUD_WATCH_LOG,
        SECURITY_LAKE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private CloudWatchDirectQueryDataSource cloudWatchLog;
        private SecurityLakeDirectQueryDataSource securityLake;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DirectQueryDataSourceType model) {
            this.cloudWatchLog(model.cloudWatchLog);
            this.securityLake(model.securityLake);
        }

        public final CloudWatchDirectQueryDataSource.Builder getCloudWatchLog() {
            return this.cloudWatchLog != null ? this.cloudWatchLog.toBuilder() : null;
        }

        public final void setCloudWatchLog(CloudWatchDirectQueryDataSource.BuilderImpl cloudWatchLog) {
            CloudWatchDirectQueryDataSource oldValue = this.cloudWatchLog;
            this.cloudWatchLog = cloudWatchLog != null ? cloudWatchLog.build() : null;
            this.handleUnionValueChange(Type.CLOUD_WATCH_LOG, oldValue, this.cloudWatchLog);
        }

        @Override
        public final Builder cloudWatchLog(CloudWatchDirectQueryDataSource cloudWatchLog) {
            CloudWatchDirectQueryDataSource oldValue = this.cloudWatchLog;
            this.cloudWatchLog = cloudWatchLog;
            this.handleUnionValueChange(Type.CLOUD_WATCH_LOG, oldValue, this.cloudWatchLog);
            return this;
        }

        public final SecurityLakeDirectQueryDataSource.Builder getSecurityLake() {
            return this.securityLake != null ? this.securityLake.toBuilder() : null;
        }

        public final void setSecurityLake(SecurityLakeDirectQueryDataSource.BuilderImpl securityLake) {
            SecurityLakeDirectQueryDataSource oldValue = this.securityLake;
            this.securityLake = securityLake != null ? securityLake.build() : null;
            this.handleUnionValueChange(Type.SECURITY_LAKE, oldValue, this.securityLake);
        }

        @Override
        public final Builder securityLake(SecurityLakeDirectQueryDataSource securityLake) {
            SecurityLakeDirectQueryDataSource oldValue = this.securityLake;
            this.securityLake = securityLake;
            this.handleUnionValueChange(Type.SECURITY_LAKE, oldValue, this.securityLake);
            return this;
        }

        public DirectQueryDataSourceType build() {
            return new DirectQueryDataSourceType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DirectQueryDataSourceType> {
        public Builder cloudWatchLog(CloudWatchDirectQueryDataSource var1);

        default public Builder cloudWatchLog(Consumer<CloudWatchDirectQueryDataSource.Builder> cloudWatchLog) {
            return this.cloudWatchLog((CloudWatchDirectQueryDataSource)((CloudWatchDirectQueryDataSource.Builder)CloudWatchDirectQueryDataSource.builder().applyMutation(cloudWatchLog)).build());
        }

        public Builder securityLake(SecurityLakeDirectQueryDataSource var1);

        default public Builder securityLake(Consumer<SecurityLakeDirectQueryDataSource.Builder> securityLake) {
            return this.securityLake((SecurityLakeDirectQueryDataSource)((SecurityLakeDirectQueryDataSource.Builder)SecurityLakeDirectQueryDataSource.builder().applyMutation(securityLake)).build());
        }
    }
}

