/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.SAMLIdp;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SAMLOptionsInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SAMLOptionsInput> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(SAMLOptionsInput.getter(SAMLOptionsInput::enabled)).setter(SAMLOptionsInput.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<SAMLIdp> IDP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Idp").getter(SAMLOptionsInput.getter(SAMLOptionsInput::idp)).setter(SAMLOptionsInput.setter(Builder::idp)).constructor(SAMLIdp::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Idp").build()}).build();
    private static final SdkField<String> MASTER_USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterUserName").getter(SAMLOptionsInput.getter(SAMLOptionsInput::masterUserName)).setter(SAMLOptionsInput.setter(Builder::masterUserName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserName").build()}).build();
    private static final SdkField<String> MASTER_BACKEND_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterBackendRole").getter(SAMLOptionsInput.getter(SAMLOptionsInput::masterBackendRole)).setter(SAMLOptionsInput.setter(Builder::masterBackendRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterBackendRole").build()}).build();
    private static final SdkField<String> SUBJECT_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubjectKey").getter(SAMLOptionsInput.getter(SAMLOptionsInput::subjectKey)).setter(SAMLOptionsInput.setter(Builder::subjectKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubjectKey").build()}).build();
    private static final SdkField<String> ROLES_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RolesKey").getter(SAMLOptionsInput.getter(SAMLOptionsInput::rolesKey)).setter(SAMLOptionsInput.setter(Builder::rolesKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RolesKey").build()}).build();
    private static final SdkField<Integer> SESSION_TIMEOUT_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SessionTimeoutMinutes").getter(SAMLOptionsInput.getter(SAMLOptionsInput::sessionTimeoutMinutes)).setter(SAMLOptionsInput.setter(Builder::sessionTimeoutMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionTimeoutMinutes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, IDP_FIELD, MASTER_USER_NAME_FIELD, MASTER_BACKEND_ROLE_FIELD, SUBJECT_KEY_FIELD, ROLES_KEY_FIELD, SESSION_TIMEOUT_MINUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SAMLOptionsInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final SAMLIdp idp;
    private final String masterUserName;
    private final String masterBackendRole;
    private final String subjectKey;
    private final String rolesKey;
    private final Integer sessionTimeoutMinutes;

    private SAMLOptionsInput(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.idp = builder.idp;
        this.masterUserName = builder.masterUserName;
        this.masterBackendRole = builder.masterBackendRole;
        this.subjectKey = builder.subjectKey;
        this.rolesKey = builder.rolesKey;
        this.sessionTimeoutMinutes = builder.sessionTimeoutMinutes;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final SAMLIdp idp() {
        return this.idp;
    }

    public final String masterUserName() {
        return this.masterUserName;
    }

    public final String masterBackendRole() {
        return this.masterBackendRole;
    }

    public final String subjectKey() {
        return this.subjectKey;
    }

    public final String rolesKey() {
        return this.rolesKey;
    }

    public final Integer sessionTimeoutMinutes() {
        return this.sessionTimeoutMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.idp());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUserName());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterBackendRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.subjectKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.rolesKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionTimeoutMinutes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SAMLOptionsInput)) {
            return false;
        }
        SAMLOptionsInput other = (SAMLOptionsInput)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.idp(), other.idp()) && Objects.equals(this.masterUserName(), other.masterUserName()) && Objects.equals(this.masterBackendRole(), other.masterBackendRole()) && Objects.equals(this.subjectKey(), other.subjectKey()) && Objects.equals(this.rolesKey(), other.rolesKey()) && Objects.equals(this.sessionTimeoutMinutes(), other.sessionTimeoutMinutes());
    }

    public final String toString() {
        return ToString.builder((String)"SAMLOptionsInput").add("Enabled", (Object)this.enabled()).add("Idp", (Object)this.idp()).add("MasterUserName", (Object)(this.masterUserName() == null ? null : "*** Sensitive Data Redacted ***")).add("MasterBackendRole", (Object)this.masterBackendRole()).add("SubjectKey", (Object)this.subjectKey()).add("RolesKey", (Object)this.rolesKey()).add("SessionTimeoutMinutes", (Object)this.sessionTimeoutMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "Idp": {
                return Optional.ofNullable(clazz.cast(this.idp()));
            }
            case "MasterUserName": {
                return Optional.ofNullable(clazz.cast(this.masterUserName()));
            }
            case "MasterBackendRole": {
                return Optional.ofNullable(clazz.cast(this.masterBackendRole()));
            }
            case "SubjectKey": {
                return Optional.ofNullable(clazz.cast(this.subjectKey()));
            }
            case "RolesKey": {
                return Optional.ofNullable(clazz.cast(this.rolesKey()));
            }
            case "SessionTimeoutMinutes": {
                return Optional.ofNullable(clazz.cast(this.sessionTimeoutMinutes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Enabled", ENABLED_FIELD);
        map.put("Idp", IDP_FIELD);
        map.put("MasterUserName", MASTER_USER_NAME_FIELD);
        map.put("MasterBackendRole", MASTER_BACKEND_ROLE_FIELD);
        map.put("SubjectKey", SUBJECT_KEY_FIELD);
        map.put("RolesKey", ROLES_KEY_FIELD);
        map.put("SessionTimeoutMinutes", SESSION_TIMEOUT_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SAMLOptionsInput, T> g) {
        return obj -> g.apply((SAMLOptionsInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private SAMLIdp idp;
        private String masterUserName;
        private String masterBackendRole;
        private String subjectKey;
        private String rolesKey;
        private Integer sessionTimeoutMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(SAMLOptionsInput model) {
            this.enabled(model.enabled);
            this.idp(model.idp);
            this.masterUserName(model.masterUserName);
            this.masterBackendRole(model.masterBackendRole);
            this.subjectKey(model.subjectKey);
            this.rolesKey(model.rolesKey);
            this.sessionTimeoutMinutes(model.sessionTimeoutMinutes);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final SAMLIdp.Builder getIdp() {
            return this.idp != null ? this.idp.toBuilder() : null;
        }

        public final void setIdp(SAMLIdp.BuilderImpl idp) {
            this.idp = idp != null ? idp.build() : null;
        }

        @Override
        public final Builder idp(SAMLIdp idp) {
            this.idp = idp;
            return this;
        }

        public final String getMasterUserName() {
            return this.masterUserName;
        }

        public final void setMasterUserName(String masterUserName) {
            this.masterUserName = masterUserName;
        }

        @Override
        public final Builder masterUserName(String masterUserName) {
            this.masterUserName = masterUserName;
            return this;
        }

        public final String getMasterBackendRole() {
            return this.masterBackendRole;
        }

        public final void setMasterBackendRole(String masterBackendRole) {
            this.masterBackendRole = masterBackendRole;
        }

        @Override
        public final Builder masterBackendRole(String masterBackendRole) {
            this.masterBackendRole = masterBackendRole;
            return this;
        }

        public final String getSubjectKey() {
            return this.subjectKey;
        }

        public final void setSubjectKey(String subjectKey) {
            this.subjectKey = subjectKey;
        }

        @Override
        public final Builder subjectKey(String subjectKey) {
            this.subjectKey = subjectKey;
            return this;
        }

        public final String getRolesKey() {
            return this.rolesKey;
        }

        public final void setRolesKey(String rolesKey) {
            this.rolesKey = rolesKey;
        }

        @Override
        public final Builder rolesKey(String rolesKey) {
            this.rolesKey = rolesKey;
            return this;
        }

        public final Integer getSessionTimeoutMinutes() {
            return this.sessionTimeoutMinutes;
        }

        public final void setSessionTimeoutMinutes(Integer sessionTimeoutMinutes) {
            this.sessionTimeoutMinutes = sessionTimeoutMinutes;
        }

        @Override
        public final Builder sessionTimeoutMinutes(Integer sessionTimeoutMinutes) {
            this.sessionTimeoutMinutes = sessionTimeoutMinutes;
            return this;
        }

        public SAMLOptionsInput build() {
            return new SAMLOptionsInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SAMLOptionsInput> {
        public Builder enabled(Boolean var1);

        public Builder idp(SAMLIdp var1);

        default public Builder idp(Consumer<SAMLIdp.Builder> idp) {
            return this.idp((SAMLIdp)((SAMLIdp.Builder)SAMLIdp.builder().applyMutation(idp)).build());
        }

        public Builder masterUserName(String var1);

        public Builder masterBackendRole(String var1);

        public Builder subjectKey(String var1);

        public Builder rolesKey(String var1);

        public Builder sessionTimeoutMinutes(Integer var1);
    }
}

