/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.osis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.osis.model.OsisResponse;
import software.amazon.awssdk.services.osis.model.PipelineEndpoint;
import software.amazon.awssdk.services.osis.model.PipelineEndpointsSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPipelineEndpointsResponse
extends OsisResponse
implements ToCopyableBuilder<Builder, ListPipelineEndpointsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPipelineEndpointsResponse.getter(ListPipelineEndpointsResponse::nextToken)).setter(ListPipelineEndpointsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<PipelineEndpoint>> PIPELINE_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PipelineEndpoints").getter(ListPipelineEndpointsResponse.getter(ListPipelineEndpointsResponse::pipelineEndpoints)).setter(ListPipelineEndpointsResponse.setter(Builder::pipelineEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PipelineEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PIPELINE_ENDPOINTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPipelineEndpointsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<PipelineEndpoint> pipelineEndpoints;

    private ListPipelineEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.pipelineEndpoints = builder.pipelineEndpoints;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasPipelineEndpoints() {
        return this.pipelineEndpoints != null && !(this.pipelineEndpoints instanceof SdkAutoConstructList);
    }

    public final List<PipelineEndpoint> pipelineEndpoints() {
        return this.pipelineEndpoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPipelineEndpoints() ? this.pipelineEndpoints() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipelineEndpointsResponse)) {
            return false;
        }
        ListPipelineEndpointsResponse other = (ListPipelineEndpointsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasPipelineEndpoints() == other.hasPipelineEndpoints() && Objects.equals(this.pipelineEndpoints(), other.pipelineEndpoints());
    }

    public final String toString() {
        return ToString.builder((String)"ListPipelineEndpointsResponse").add("NextToken", (Object)this.nextToken()).add("PipelineEndpoints", this.hasPipelineEndpoints() ? this.pipelineEndpoints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "PipelineEndpoints": {
                return Optional.ofNullable(clazz.cast(this.pipelineEndpoints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("PipelineEndpoints", PIPELINE_ENDPOINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPipelineEndpointsResponse, T> g) {
        return obj -> g.apply((ListPipelineEndpointsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OsisResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<PipelineEndpoint> pipelineEndpoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPipelineEndpointsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.pipelineEndpoints(model.pipelineEndpoints);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<PipelineEndpoint.Builder> getPipelineEndpoints() {
            List<PipelineEndpoint.Builder> result = PipelineEndpointsSummaryListCopier.copyToBuilder(this.pipelineEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPipelineEndpoints(Collection<PipelineEndpoint.BuilderImpl> pipelineEndpoints) {
            this.pipelineEndpoints = PipelineEndpointsSummaryListCopier.copyFromBuilder(pipelineEndpoints);
        }

        @Override
        public final Builder pipelineEndpoints(Collection<PipelineEndpoint> pipelineEndpoints) {
            this.pipelineEndpoints = PipelineEndpointsSummaryListCopier.copy(pipelineEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineEndpoints(PipelineEndpoint ... pipelineEndpoints) {
            this.pipelineEndpoints(Arrays.asList(pipelineEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineEndpoints(Consumer<PipelineEndpoint.Builder> ... pipelineEndpoints) {
            this.pipelineEndpoints(Stream.of(pipelineEndpoints).map(c -> (PipelineEndpoint)((PipelineEndpoint.Builder)PipelineEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPipelineEndpointsResponse build() {
            return new ListPipelineEndpointsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OsisResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPipelineEndpointsResponse> {
        public Builder nextToken(String var1);

        public Builder pipelineEndpoints(Collection<PipelineEndpoint> var1);

        public Builder pipelineEndpoints(PipelineEndpoint ... var1);

        public Builder pipelineEndpoints(Consumer<PipelineEndpoint.Builder> ... var1);
    }
}

