/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SubscriptionType {
    ORIGINAL("ORIGINAL"),
    RENEWAL("RENEWAL"),
    CAPACITY_INCREASE("CAPACITY_INCREASE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SubscriptionType> VALUE_MAP;
    private final String value;

    private SubscriptionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SubscriptionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SubscriptionType> knownValues() {
        EnumSet<SubscriptionType> knownValues = EnumSet.allOf(SubscriptionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SubscriptionType.class, SubscriptionType::toString);
    }
}

