/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralselling.model.ApnProgramsCopier;
import software.amazon.awssdk.services.partnercentralselling.model.CompetitorName;
import software.amazon.awssdk.services.partnercentralselling.model.DeliveryModel;
import software.amazon.awssdk.services.partnercentralselling.model.DeliveryModelsCopier;
import software.amazon.awssdk.services.partnercentralselling.model.ExpectedCustomerSpend;
import software.amazon.awssdk.services.partnercentralselling.model.ExpectedCustomerSpendListCopier;
import software.amazon.awssdk.services.partnercentralselling.model.SalesActivitiesCopier;
import software.amazon.awssdk.services.partnercentralselling.model.SalesActivity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Project
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Project> {
    private static final SdkField<List<String>> DELIVERY_MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeliveryModels").getter(Project.getter(Project::deliveryModelsAsStrings)).setter(Project.setter(Builder::deliveryModelsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryModels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ExpectedCustomerSpend>> EXPECTED_CUSTOMER_SPEND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExpectedCustomerSpend").getter(Project.getter(Project::expectedCustomerSpend)).setter(Project.setter(Builder::expectedCustomerSpend)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedCustomerSpend").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExpectedCustomerSpend::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(Project.getter(Project::title)).setter(Project.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<List<String>> APN_PROGRAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ApnPrograms").getter(Project.getter(Project::apnPrograms)).setter(Project.setter(Builder::apnPrograms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApnPrograms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CUSTOMER_BUSINESS_PROBLEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerBusinessProblem").getter(Project.getter(Project::customerBusinessProblem)).setter(Project.setter(Builder::customerBusinessProblem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerBusinessProblem").build()}).build();
    private static final SdkField<String> CUSTOMER_USE_CASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerUseCase").getter(Project.getter(Project::customerUseCase)).setter(Project.setter(Builder::customerUseCase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerUseCase").build()}).build();
    private static final SdkField<String> RELATED_OPPORTUNITY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelatedOpportunityIdentifier").getter(Project.getter(Project::relatedOpportunityIdentifier)).setter(Project.setter(Builder::relatedOpportunityIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedOpportunityIdentifier").build()}).build();
    private static final SdkField<List<String>> SALES_ACTIVITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SalesActivities").getter(Project.getter(Project::salesActivitiesAsStrings)).setter(Project.setter(Builder::salesActivitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SalesActivities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> COMPETITOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompetitorName").getter(Project.getter(Project::competitorNameAsString)).setter(Project.setter(Builder::competitorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompetitorName").build()}).build();
    private static final SdkField<String> OTHER_COMPETITOR_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OtherCompetitorNames").getter(Project.getter(Project::otherCompetitorNames)).setter(Project.setter(Builder::otherCompetitorNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherCompetitorNames").build()}).build();
    private static final SdkField<String> OTHER_SOLUTION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OtherSolutionDescription").getter(Project.getter(Project::otherSolutionDescription)).setter(Project.setter(Builder::otherSolutionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherSolutionDescription").build()}).build();
    private static final SdkField<String> ADDITIONAL_COMMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdditionalComments").getter(Project.getter(Project::additionalComments)).setter(Project.setter(Builder::additionalComments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalComments").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_MODELS_FIELD, EXPECTED_CUSTOMER_SPEND_FIELD, TITLE_FIELD, APN_PROGRAMS_FIELD, CUSTOMER_BUSINESS_PROBLEM_FIELD, CUSTOMER_USE_CASE_FIELD, RELATED_OPPORTUNITY_IDENTIFIER_FIELD, SALES_ACTIVITIES_FIELD, COMPETITOR_NAME_FIELD, OTHER_COMPETITOR_NAMES_FIELD, OTHER_SOLUTION_DESCRIPTION_FIELD, ADDITIONAL_COMMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Project.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> deliveryModels;
    private final List<ExpectedCustomerSpend> expectedCustomerSpend;
    private final String title;
    private final List<String> apnPrograms;
    private final String customerBusinessProblem;
    private final String customerUseCase;
    private final String relatedOpportunityIdentifier;
    private final List<String> salesActivities;
    private final String competitorName;
    private final String otherCompetitorNames;
    private final String otherSolutionDescription;
    private final String additionalComments;

    private Project(BuilderImpl builder) {
        this.deliveryModels = builder.deliveryModels;
        this.expectedCustomerSpend = builder.expectedCustomerSpend;
        this.title = builder.title;
        this.apnPrograms = builder.apnPrograms;
        this.customerBusinessProblem = builder.customerBusinessProblem;
        this.customerUseCase = builder.customerUseCase;
        this.relatedOpportunityIdentifier = builder.relatedOpportunityIdentifier;
        this.salesActivities = builder.salesActivities;
        this.competitorName = builder.competitorName;
        this.otherCompetitorNames = builder.otherCompetitorNames;
        this.otherSolutionDescription = builder.otherSolutionDescription;
        this.additionalComments = builder.additionalComments;
    }

    public final List<DeliveryModel> deliveryModels() {
        return DeliveryModelsCopier.copyStringToEnum(this.deliveryModels);
    }

    public final boolean hasDeliveryModels() {
        return this.deliveryModels != null && !(this.deliveryModels instanceof SdkAutoConstructList);
    }

    public final List<String> deliveryModelsAsStrings() {
        return this.deliveryModels;
    }

    public final boolean hasExpectedCustomerSpend() {
        return this.expectedCustomerSpend != null && !(this.expectedCustomerSpend instanceof SdkAutoConstructList);
    }

    public final List<ExpectedCustomerSpend> expectedCustomerSpend() {
        return this.expectedCustomerSpend;
    }

    public final String title() {
        return this.title;
    }

    public final boolean hasApnPrograms() {
        return this.apnPrograms != null && !(this.apnPrograms instanceof SdkAutoConstructList);
    }

    public final List<String> apnPrograms() {
        return this.apnPrograms;
    }

    public final String customerBusinessProblem() {
        return this.customerBusinessProblem;
    }

    public final String customerUseCase() {
        return this.customerUseCase;
    }

    public final String relatedOpportunityIdentifier() {
        return this.relatedOpportunityIdentifier;
    }

    public final List<SalesActivity> salesActivities() {
        return SalesActivitiesCopier.copyStringToEnum(this.salesActivities);
    }

    public final boolean hasSalesActivities() {
        return this.salesActivities != null && !(this.salesActivities instanceof SdkAutoConstructList);
    }

    public final List<String> salesActivitiesAsStrings() {
        return this.salesActivities;
    }

    public final CompetitorName competitorName() {
        return CompetitorName.fromValue(this.competitorName);
    }

    public final String competitorNameAsString() {
        return this.competitorName;
    }

    public final String otherCompetitorNames() {
        return this.otherCompetitorNames;
    }

    public final String otherSolutionDescription() {
        return this.otherSolutionDescription;
    }

    public final String additionalComments() {
        return this.additionalComments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeliveryModels() ? this.deliveryModelsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExpectedCustomerSpend() ? this.expectedCustomerSpend() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApnPrograms() ? this.apnPrograms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.customerBusinessProblem());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerUseCase());
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedOpportunityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSalesActivities() ? this.salesActivitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.competitorNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.otherCompetitorNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.otherSolutionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalComments());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Project)) {
            return false;
        }
        Project other = (Project)obj;
        return this.hasDeliveryModels() == other.hasDeliveryModels() && Objects.equals(this.deliveryModelsAsStrings(), other.deliveryModelsAsStrings()) && this.hasExpectedCustomerSpend() == other.hasExpectedCustomerSpend() && Objects.equals(this.expectedCustomerSpend(), other.expectedCustomerSpend()) && Objects.equals(this.title(), other.title()) && this.hasApnPrograms() == other.hasApnPrograms() && Objects.equals(this.apnPrograms(), other.apnPrograms()) && Objects.equals(this.customerBusinessProblem(), other.customerBusinessProblem()) && Objects.equals(this.customerUseCase(), other.customerUseCase()) && Objects.equals(this.relatedOpportunityIdentifier(), other.relatedOpportunityIdentifier()) && this.hasSalesActivities() == other.hasSalesActivities() && Objects.equals(this.salesActivitiesAsStrings(), other.salesActivitiesAsStrings()) && Objects.equals(this.competitorNameAsString(), other.competitorNameAsString()) && Objects.equals(this.otherCompetitorNames(), other.otherCompetitorNames()) && Objects.equals(this.otherSolutionDescription(), other.otherSolutionDescription()) && Objects.equals(this.additionalComments(), other.additionalComments());
    }

    public final String toString() {
        return ToString.builder((String)"Project").add("DeliveryModels", this.hasDeliveryModels() ? this.deliveryModelsAsStrings() : null).add("ExpectedCustomerSpend", this.hasExpectedCustomerSpend() ? this.expectedCustomerSpend() : null).add("Title", (Object)(this.title() == null ? null : "*** Sensitive Data Redacted ***")).add("ApnPrograms", this.hasApnPrograms() ? this.apnPrograms() : null).add("CustomerBusinessProblem", (Object)(this.customerBusinessProblem() == null ? null : "*** Sensitive Data Redacted ***")).add("CustomerUseCase", (Object)this.customerUseCase()).add("RelatedOpportunityIdentifier", (Object)this.relatedOpportunityIdentifier()).add("SalesActivities", this.hasSalesActivities() ? this.salesActivitiesAsStrings() : null).add("CompetitorName", (Object)this.competitorNameAsString()).add("OtherCompetitorNames", (Object)this.otherCompetitorNames()).add("OtherSolutionDescription", (Object)(this.otherSolutionDescription() == null ? null : "*** Sensitive Data Redacted ***")).add("AdditionalComments", (Object)this.additionalComments()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliveryModels": {
                return Optional.ofNullable(clazz.cast(this.deliveryModelsAsStrings()));
            }
            case "ExpectedCustomerSpend": {
                return Optional.ofNullable(clazz.cast(this.expectedCustomerSpend()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "ApnPrograms": {
                return Optional.ofNullable(clazz.cast(this.apnPrograms()));
            }
            case "CustomerBusinessProblem": {
                return Optional.ofNullable(clazz.cast(this.customerBusinessProblem()));
            }
            case "CustomerUseCase": {
                return Optional.ofNullable(clazz.cast(this.customerUseCase()));
            }
            case "RelatedOpportunityIdentifier": {
                return Optional.ofNullable(clazz.cast(this.relatedOpportunityIdentifier()));
            }
            case "SalesActivities": {
                return Optional.ofNullable(clazz.cast(this.salesActivitiesAsStrings()));
            }
            case "CompetitorName": {
                return Optional.ofNullable(clazz.cast(this.competitorNameAsString()));
            }
            case "OtherCompetitorNames": {
                return Optional.ofNullable(clazz.cast(this.otherCompetitorNames()));
            }
            case "OtherSolutionDescription": {
                return Optional.ofNullable(clazz.cast(this.otherSolutionDescription()));
            }
            case "AdditionalComments": {
                return Optional.ofNullable(clazz.cast(this.additionalComments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DeliveryModels", DELIVERY_MODELS_FIELD);
        map.put("ExpectedCustomerSpend", EXPECTED_CUSTOMER_SPEND_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("ApnPrograms", APN_PROGRAMS_FIELD);
        map.put("CustomerBusinessProblem", CUSTOMER_BUSINESS_PROBLEM_FIELD);
        map.put("CustomerUseCase", CUSTOMER_USE_CASE_FIELD);
        map.put("RelatedOpportunityIdentifier", RELATED_OPPORTUNITY_IDENTIFIER_FIELD);
        map.put("SalesActivities", SALES_ACTIVITIES_FIELD);
        map.put("CompetitorName", COMPETITOR_NAME_FIELD);
        map.put("OtherCompetitorNames", OTHER_COMPETITOR_NAMES_FIELD);
        map.put("OtherSolutionDescription", OTHER_SOLUTION_DESCRIPTION_FIELD);
        map.put("AdditionalComments", ADDITIONAL_COMMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Project, T> g) {
        return obj -> g.apply((Project)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> deliveryModels = DefaultSdkAutoConstructList.getInstance();
        private List<ExpectedCustomerSpend> expectedCustomerSpend = DefaultSdkAutoConstructList.getInstance();
        private String title;
        private List<String> apnPrograms = DefaultSdkAutoConstructList.getInstance();
        private String customerBusinessProblem;
        private String customerUseCase;
        private String relatedOpportunityIdentifier;
        private List<String> salesActivities = DefaultSdkAutoConstructList.getInstance();
        private String competitorName;
        private String otherCompetitorNames;
        private String otherSolutionDescription;
        private String additionalComments;

        private BuilderImpl() {
        }

        private BuilderImpl(Project model) {
            this.deliveryModelsWithStrings(model.deliveryModels);
            this.expectedCustomerSpend(model.expectedCustomerSpend);
            this.title(model.title);
            this.apnPrograms(model.apnPrograms);
            this.customerBusinessProblem(model.customerBusinessProblem);
            this.customerUseCase(model.customerUseCase);
            this.relatedOpportunityIdentifier(model.relatedOpportunityIdentifier);
            this.salesActivitiesWithStrings(model.salesActivities);
            this.competitorName(model.competitorName);
            this.otherCompetitorNames(model.otherCompetitorNames);
            this.otherSolutionDescription(model.otherSolutionDescription);
            this.additionalComments(model.additionalComments);
        }

        public final Collection<String> getDeliveryModels() {
            if (this.deliveryModels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deliveryModels;
        }

        public final void setDeliveryModels(Collection<String> deliveryModels) {
            this.deliveryModels = DeliveryModelsCopier.copy(deliveryModels);
        }

        @Override
        public final Builder deliveryModelsWithStrings(Collection<String> deliveryModels) {
            this.deliveryModels = DeliveryModelsCopier.copy(deliveryModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryModelsWithStrings(String ... deliveryModels) {
            this.deliveryModelsWithStrings(Arrays.asList(deliveryModels));
            return this;
        }

        @Override
        public final Builder deliveryModels(Collection<DeliveryModel> deliveryModels) {
            this.deliveryModels = DeliveryModelsCopier.copyEnumToString(deliveryModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryModels(DeliveryModel ... deliveryModels) {
            this.deliveryModels(Arrays.asList(deliveryModels));
            return this;
        }

        public final List<ExpectedCustomerSpend.Builder> getExpectedCustomerSpend() {
            List<ExpectedCustomerSpend.Builder> result = ExpectedCustomerSpendListCopier.copyToBuilder(this.expectedCustomerSpend);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExpectedCustomerSpend(Collection<ExpectedCustomerSpend.BuilderImpl> expectedCustomerSpend) {
            this.expectedCustomerSpend = ExpectedCustomerSpendListCopier.copyFromBuilder(expectedCustomerSpend);
        }

        @Override
        public final Builder expectedCustomerSpend(Collection<ExpectedCustomerSpend> expectedCustomerSpend) {
            this.expectedCustomerSpend = ExpectedCustomerSpendListCopier.copy(expectedCustomerSpend);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expectedCustomerSpend(ExpectedCustomerSpend ... expectedCustomerSpend) {
            this.expectedCustomerSpend(Arrays.asList(expectedCustomerSpend));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expectedCustomerSpend(Consumer<ExpectedCustomerSpend.Builder> ... expectedCustomerSpend) {
            this.expectedCustomerSpend(Stream.of(expectedCustomerSpend).map(c -> (ExpectedCustomerSpend)((ExpectedCustomerSpend.Builder)ExpectedCustomerSpend.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final Collection<String> getApnPrograms() {
            if (this.apnPrograms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.apnPrograms;
        }

        public final void setApnPrograms(Collection<String> apnPrograms) {
            this.apnPrograms = ApnProgramsCopier.copy(apnPrograms);
        }

        @Override
        public final Builder apnPrograms(Collection<String> apnPrograms) {
            this.apnPrograms = ApnProgramsCopier.copy(apnPrograms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apnPrograms(String ... apnPrograms) {
            this.apnPrograms(Arrays.asList(apnPrograms));
            return this;
        }

        public final String getCustomerBusinessProblem() {
            return this.customerBusinessProblem;
        }

        public final void setCustomerBusinessProblem(String customerBusinessProblem) {
            this.customerBusinessProblem = customerBusinessProblem;
        }

        @Override
        public final Builder customerBusinessProblem(String customerBusinessProblem) {
            this.customerBusinessProblem = customerBusinessProblem;
            return this;
        }

        public final String getCustomerUseCase() {
            return this.customerUseCase;
        }

        public final void setCustomerUseCase(String customerUseCase) {
            this.customerUseCase = customerUseCase;
        }

        @Override
        public final Builder customerUseCase(String customerUseCase) {
            this.customerUseCase = customerUseCase;
            return this;
        }

        public final String getRelatedOpportunityIdentifier() {
            return this.relatedOpportunityIdentifier;
        }

        public final void setRelatedOpportunityIdentifier(String relatedOpportunityIdentifier) {
            this.relatedOpportunityIdentifier = relatedOpportunityIdentifier;
        }

        @Override
        public final Builder relatedOpportunityIdentifier(String relatedOpportunityIdentifier) {
            this.relatedOpportunityIdentifier = relatedOpportunityIdentifier;
            return this;
        }

        public final Collection<String> getSalesActivities() {
            if (this.salesActivities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.salesActivities;
        }

        public final void setSalesActivities(Collection<String> salesActivities) {
            this.salesActivities = SalesActivitiesCopier.copy(salesActivities);
        }

        @Override
        public final Builder salesActivitiesWithStrings(Collection<String> salesActivities) {
            this.salesActivities = SalesActivitiesCopier.copy(salesActivities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder salesActivitiesWithStrings(String ... salesActivities) {
            this.salesActivitiesWithStrings(Arrays.asList(salesActivities));
            return this;
        }

        @Override
        public final Builder salesActivities(Collection<SalesActivity> salesActivities) {
            this.salesActivities = SalesActivitiesCopier.copyEnumToString(salesActivities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder salesActivities(SalesActivity ... salesActivities) {
            this.salesActivities(Arrays.asList(salesActivities));
            return this;
        }

        public final String getCompetitorName() {
            return this.competitorName;
        }

        public final void setCompetitorName(String competitorName) {
            this.competitorName = competitorName;
        }

        @Override
        public final Builder competitorName(String competitorName) {
            this.competitorName = competitorName;
            return this;
        }

        @Override
        public final Builder competitorName(CompetitorName competitorName) {
            this.competitorName(competitorName == null ? null : competitorName.toString());
            return this;
        }

        public final String getOtherCompetitorNames() {
            return this.otherCompetitorNames;
        }

        public final void setOtherCompetitorNames(String otherCompetitorNames) {
            this.otherCompetitorNames = otherCompetitorNames;
        }

        @Override
        public final Builder otherCompetitorNames(String otherCompetitorNames) {
            this.otherCompetitorNames = otherCompetitorNames;
            return this;
        }

        public final String getOtherSolutionDescription() {
            return this.otherSolutionDescription;
        }

        public final void setOtherSolutionDescription(String otherSolutionDescription) {
            this.otherSolutionDescription = otherSolutionDescription;
        }

        @Override
        public final Builder otherSolutionDescription(String otherSolutionDescription) {
            this.otherSolutionDescription = otherSolutionDescription;
            return this;
        }

        public final String getAdditionalComments() {
            return this.additionalComments;
        }

        public final void setAdditionalComments(String additionalComments) {
            this.additionalComments = additionalComments;
        }

        @Override
        public final Builder additionalComments(String additionalComments) {
            this.additionalComments = additionalComments;
            return this;
        }

        public Project build() {
            return new Project(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Project> {
        public Builder deliveryModelsWithStrings(Collection<String> var1);

        public Builder deliveryModelsWithStrings(String ... var1);

        public Builder deliveryModels(Collection<DeliveryModel> var1);

        public Builder deliveryModels(DeliveryModel ... var1);

        public Builder expectedCustomerSpend(Collection<ExpectedCustomerSpend> var1);

        public Builder expectedCustomerSpend(ExpectedCustomerSpend ... var1);

        public Builder expectedCustomerSpend(Consumer<ExpectedCustomerSpend.Builder> ... var1);

        public Builder title(String var1);

        public Builder apnPrograms(Collection<String> var1);

        public Builder apnPrograms(String ... var1);

        public Builder customerBusinessProblem(String var1);

        public Builder customerUseCase(String var1);

        public Builder relatedOpportunityIdentifier(String var1);

        public Builder salesActivitiesWithStrings(Collection<String> var1);

        public Builder salesActivitiesWithStrings(String ... var1);

        public Builder salesActivities(Collection<SalesActivity> var1);

        public Builder salesActivities(SalesActivity ... var1);

        public Builder competitorName(String var1);

        public Builder competitorName(CompetitorName var1);

        public Builder otherCompetitorNames(String var1);

        public Builder otherSolutionDescription(String var1);

        public Builder additionalComments(String var1);
    }
}

