/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.partnercentralselling.model.LeadInvitationPayload;
import software.amazon.awssdk.services.partnercentralselling.model.OpportunityInvitationPayload;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Payload
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Payload> {
    private static final SdkField<OpportunityInvitationPayload> OPPORTUNITY_INVITATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OpportunityInvitation").getter(Payload.getter(Payload::opportunityInvitation)).setter(Payload.setter(Builder::opportunityInvitation)).constructor(OpportunityInvitationPayload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpportunityInvitation").build()}).build();
    private static final SdkField<LeadInvitationPayload> LEAD_INVITATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LeadInvitation").getter(Payload.getter(Payload::leadInvitation)).setter(Payload.setter(Builder::leadInvitation)).constructor(LeadInvitationPayload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LeadInvitation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPPORTUNITY_INVITATION_FIELD, LEAD_INVITATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Payload.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final OpportunityInvitationPayload opportunityInvitation;
    private final LeadInvitationPayload leadInvitation;
    private final Type type;

    private Payload(BuilderImpl builder) {
        this.opportunityInvitation = builder.opportunityInvitation;
        this.leadInvitation = builder.leadInvitation;
        this.type = builder.type;
    }

    public final OpportunityInvitationPayload opportunityInvitation() {
        return this.opportunityInvitation;
    }

    public final LeadInvitationPayload leadInvitation() {
        return this.leadInvitation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.opportunityInvitation());
        hashCode = 31 * hashCode + Objects.hashCode(this.leadInvitation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Payload)) {
            return false;
        }
        Payload other = (Payload)obj;
        return Objects.equals(this.opportunityInvitation(), other.opportunityInvitation()) && Objects.equals(this.leadInvitation(), other.leadInvitation());
    }

    public final String toString() {
        return ToString.builder((String)"Payload").add("OpportunityInvitation", (Object)this.opportunityInvitation()).add("LeadInvitation", (Object)this.leadInvitation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OpportunityInvitation": {
                return Optional.ofNullable(clazz.cast(this.opportunityInvitation()));
            }
            case "LeadInvitation": {
                return Optional.ofNullable(clazz.cast(this.leadInvitation()));
            }
        }
        return Optional.empty();
    }

    public static Payload fromOpportunityInvitation(OpportunityInvitationPayload opportunityInvitation) {
        return (Payload)Payload.builder().opportunityInvitation(opportunityInvitation).build();
    }

    public static Payload fromOpportunityInvitation(Consumer<OpportunityInvitationPayload.Builder> opportunityInvitation) {
        OpportunityInvitationPayload.Builder builder = OpportunityInvitationPayload.builder();
        opportunityInvitation.accept(builder);
        return Payload.fromOpportunityInvitation((OpportunityInvitationPayload)builder.build());
    }

    public static Payload fromLeadInvitation(LeadInvitationPayload leadInvitation) {
        return (Payload)Payload.builder().leadInvitation(leadInvitation).build();
    }

    public static Payload fromLeadInvitation(Consumer<LeadInvitationPayload.Builder> leadInvitation) {
        LeadInvitationPayload.Builder builder = LeadInvitationPayload.builder();
        leadInvitation.accept(builder);
        return Payload.fromLeadInvitation((LeadInvitationPayload)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OpportunityInvitation", OPPORTUNITY_INVITATION_FIELD);
        map.put("LeadInvitation", LEAD_INVITATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Payload, T> g) {
        return obj -> g.apply((Payload)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        OPPORTUNITY_INVITATION,
        LEAD_INVITATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private OpportunityInvitationPayload opportunityInvitation;
        private LeadInvitationPayload leadInvitation;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Payload model) {
            this.opportunityInvitation(model.opportunityInvitation);
            this.leadInvitation(model.leadInvitation);
        }

        public final OpportunityInvitationPayload.Builder getOpportunityInvitation() {
            return this.opportunityInvitation != null ? this.opportunityInvitation.toBuilder() : null;
        }

        public final void setOpportunityInvitation(OpportunityInvitationPayload.BuilderImpl opportunityInvitation) {
            OpportunityInvitationPayload oldValue = this.opportunityInvitation;
            this.opportunityInvitation = opportunityInvitation != null ? opportunityInvitation.build() : null;
            this.handleUnionValueChange(Type.OPPORTUNITY_INVITATION, oldValue, this.opportunityInvitation);
        }

        @Override
        public final Builder opportunityInvitation(OpportunityInvitationPayload opportunityInvitation) {
            OpportunityInvitationPayload oldValue = this.opportunityInvitation;
            this.opportunityInvitation = opportunityInvitation;
            this.handleUnionValueChange(Type.OPPORTUNITY_INVITATION, oldValue, this.opportunityInvitation);
            return this;
        }

        public final LeadInvitationPayload.Builder getLeadInvitation() {
            return this.leadInvitation != null ? this.leadInvitation.toBuilder() : null;
        }

        public final void setLeadInvitation(LeadInvitationPayload.BuilderImpl leadInvitation) {
            LeadInvitationPayload oldValue = this.leadInvitation;
            this.leadInvitation = leadInvitation != null ? leadInvitation.build() : null;
            this.handleUnionValueChange(Type.LEAD_INVITATION, oldValue, this.leadInvitation);
        }

        @Override
        public final Builder leadInvitation(LeadInvitationPayload leadInvitation) {
            LeadInvitationPayload oldValue = this.leadInvitation;
            this.leadInvitation = leadInvitation;
            this.handleUnionValueChange(Type.LEAD_INVITATION, oldValue, this.leadInvitation);
            return this;
        }

        public Payload build() {
            return new Payload(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Payload> {
        public Builder opportunityInvitation(OpportunityInvitationPayload var1);

        default public Builder opportunityInvitation(Consumer<OpportunityInvitationPayload.Builder> opportunityInvitation) {
            return this.opportunityInvitation((OpportunityInvitationPayload)((OpportunityInvitationPayload.Builder)OpportunityInvitationPayload.builder().applyMutation(opportunityInvitation)).build());
        }

        public Builder leadInvitation(LeadInvitationPayload var1);

        default public Builder leadInvitation(Consumer<LeadInvitationPayload.Builder> leadInvitation) {
            return this.leadInvitation((LeadInvitationPayload)((LeadInvitationPayload.Builder)LeadInvitationPayload.builder().applyMutation(leadInvitation)).build());
        }
    }
}

