/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptography.model.WrappingKeySpec;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportKeyCryptogram
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportKeyCryptogram> {
    private static final SdkField<String> CERTIFICATE_AUTHORITY_PUBLIC_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateAuthorityPublicKeyIdentifier").getter(ExportKeyCryptogram.getter(ExportKeyCryptogram::certificateAuthorityPublicKeyIdentifier)).setter(ExportKeyCryptogram.setter(Builder::certificateAuthorityPublicKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityPublicKeyIdentifier").build()}).build();
    private static final SdkField<String> WRAPPING_KEY_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WrappingKeyCertificate").getter(ExportKeyCryptogram.getter(ExportKeyCryptogram::wrappingKeyCertificate)).setter(ExportKeyCryptogram.setter(Builder::wrappingKeyCertificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappingKeyCertificate").build()}).build();
    private static final SdkField<String> WRAPPING_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WrappingSpec").getter(ExportKeyCryptogram.getter(ExportKeyCryptogram::wrappingSpecAsString)).setter(ExportKeyCryptogram.setter(Builder::wrappingSpec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappingSpec").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_AUTHORITY_PUBLIC_KEY_IDENTIFIER_FIELD, WRAPPING_KEY_CERTIFICATE_FIELD, WRAPPING_SPEC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExportKeyCryptogram.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String certificateAuthorityPublicKeyIdentifier;
    private final String wrappingKeyCertificate;
    private final String wrappingSpec;

    private ExportKeyCryptogram(BuilderImpl builder) {
        this.certificateAuthorityPublicKeyIdentifier = builder.certificateAuthorityPublicKeyIdentifier;
        this.wrappingKeyCertificate = builder.wrappingKeyCertificate;
        this.wrappingSpec = builder.wrappingSpec;
    }

    public final String certificateAuthorityPublicKeyIdentifier() {
        return this.certificateAuthorityPublicKeyIdentifier;
    }

    public final String wrappingKeyCertificate() {
        return this.wrappingKeyCertificate;
    }

    public final WrappingKeySpec wrappingSpec() {
        return WrappingKeySpec.fromValue(this.wrappingSpec);
    }

    public final String wrappingSpecAsString() {
        return this.wrappingSpec;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAuthorityPublicKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.wrappingKeyCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.wrappingSpecAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportKeyCryptogram)) {
            return false;
        }
        ExportKeyCryptogram other = (ExportKeyCryptogram)obj;
        return Objects.equals(this.certificateAuthorityPublicKeyIdentifier(), other.certificateAuthorityPublicKeyIdentifier()) && Objects.equals(this.wrappingKeyCertificate(), other.wrappingKeyCertificate()) && Objects.equals(this.wrappingSpecAsString(), other.wrappingSpecAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ExportKeyCryptogram").add("CertificateAuthorityPublicKeyIdentifier", (Object)this.certificateAuthorityPublicKeyIdentifier()).add("WrappingKeyCertificate", (Object)this.wrappingKeyCertificate()).add("WrappingSpec", (Object)this.wrappingSpecAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateAuthorityPublicKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthorityPublicKeyIdentifier()));
            }
            case "WrappingKeyCertificate": {
                return Optional.ofNullable(clazz.cast(this.wrappingKeyCertificate()));
            }
            case "WrappingSpec": {
                return Optional.ofNullable(clazz.cast(this.wrappingSpecAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("CertificateAuthorityPublicKeyIdentifier", CERTIFICATE_AUTHORITY_PUBLIC_KEY_IDENTIFIER_FIELD);
        map.put("WrappingKeyCertificate", WRAPPING_KEY_CERTIFICATE_FIELD);
        map.put("WrappingSpec", WRAPPING_SPEC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportKeyCryptogram, T> g) {
        return obj -> g.apply((ExportKeyCryptogram)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateAuthorityPublicKeyIdentifier;
        private String wrappingKeyCertificate;
        private String wrappingSpec;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportKeyCryptogram model) {
            this.certificateAuthorityPublicKeyIdentifier(model.certificateAuthorityPublicKeyIdentifier);
            this.wrappingKeyCertificate(model.wrappingKeyCertificate);
            this.wrappingSpec(model.wrappingSpec);
        }

        public final String getCertificateAuthorityPublicKeyIdentifier() {
            return this.certificateAuthorityPublicKeyIdentifier;
        }

        public final void setCertificateAuthorityPublicKeyIdentifier(String certificateAuthorityPublicKeyIdentifier) {
            this.certificateAuthorityPublicKeyIdentifier = certificateAuthorityPublicKeyIdentifier;
        }

        @Override
        public final Builder certificateAuthorityPublicKeyIdentifier(String certificateAuthorityPublicKeyIdentifier) {
            this.certificateAuthorityPublicKeyIdentifier = certificateAuthorityPublicKeyIdentifier;
            return this;
        }

        public final String getWrappingKeyCertificate() {
            return this.wrappingKeyCertificate;
        }

        public final void setWrappingKeyCertificate(String wrappingKeyCertificate) {
            this.wrappingKeyCertificate = wrappingKeyCertificate;
        }

        @Override
        public final Builder wrappingKeyCertificate(String wrappingKeyCertificate) {
            this.wrappingKeyCertificate = wrappingKeyCertificate;
            return this;
        }

        public final String getWrappingSpec() {
            return this.wrappingSpec;
        }

        public final void setWrappingSpec(String wrappingSpec) {
            this.wrappingSpec = wrappingSpec;
        }

        @Override
        public final Builder wrappingSpec(String wrappingSpec) {
            this.wrappingSpec = wrappingSpec;
            return this;
        }

        @Override
        public final Builder wrappingSpec(WrappingKeySpec wrappingSpec) {
            this.wrappingSpec(wrappingSpec == null ? null : wrappingSpec.toString());
            return this;
        }

        public ExportKeyCryptogram build() {
            return new ExportKeyCryptogram(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportKeyCryptogram> {
        public Builder certificateAuthorityPublicKeyIdentifier(String var1);

        public Builder wrappingKeyCertificate(String var1);

        public Builder wrappingSpec(String var1);

        public Builder wrappingSpec(WrappingKeySpec var1);
    }
}

