/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptographydata.model.KeyDerivationFunction;
import software.amazon.awssdk.services.paymentcryptographydata.model.KeyDerivationHashAlgorithm;
import software.amazon.awssdk.services.paymentcryptographydata.model.SymmetricKeyAlgorithm;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EcdhDerivationAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EcdhDerivationAttributes> {
    private static final SdkField<String> CERTIFICATE_AUTHORITY_PUBLIC_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateAuthorityPublicKeyIdentifier").getter(EcdhDerivationAttributes.getter(EcdhDerivationAttributes::certificateAuthorityPublicKeyIdentifier)).setter(EcdhDerivationAttributes.setter(Builder::certificateAuthorityPublicKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityPublicKeyIdentifier").build()}).build();
    private static final SdkField<String> PUBLIC_KEY_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicKeyCertificate").getter(EcdhDerivationAttributes.getter(EcdhDerivationAttributes::publicKeyCertificate)).setter(EcdhDerivationAttributes.setter(Builder::publicKeyCertificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKeyCertificate").build()}).build();
    private static final SdkField<String> KEY_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyAlgorithm").getter(EcdhDerivationAttributes.getter(EcdhDerivationAttributes::keyAlgorithmAsString)).setter(EcdhDerivationAttributes.setter(Builder::keyAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAlgorithm").build()}).build();
    private static final SdkField<String> KEY_DERIVATION_FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyDerivationFunction").getter(EcdhDerivationAttributes.getter(EcdhDerivationAttributes::keyDerivationFunctionAsString)).setter(EcdhDerivationAttributes.setter(Builder::keyDerivationFunction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyDerivationFunction").build()}).build();
    private static final SdkField<String> KEY_DERIVATION_HASH_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyDerivationHashAlgorithm").getter(EcdhDerivationAttributes.getter(EcdhDerivationAttributes::keyDerivationHashAlgorithmAsString)).setter(EcdhDerivationAttributes.setter(Builder::keyDerivationHashAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyDerivationHashAlgorithm").build()}).build();
    private static final SdkField<String> SHARED_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SharedInformation").getter(EcdhDerivationAttributes.getter(EcdhDerivationAttributes::sharedInformation)).setter(EcdhDerivationAttributes.setter(Builder::sharedInformation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedInformation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_AUTHORITY_PUBLIC_KEY_IDENTIFIER_FIELD, PUBLIC_KEY_CERTIFICATE_FIELD, KEY_ALGORITHM_FIELD, KEY_DERIVATION_FUNCTION_FIELD, KEY_DERIVATION_HASH_ALGORITHM_FIELD, SHARED_INFORMATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EcdhDerivationAttributes.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String certificateAuthorityPublicKeyIdentifier;
    private final String publicKeyCertificate;
    private final String keyAlgorithm;
    private final String keyDerivationFunction;
    private final String keyDerivationHashAlgorithm;
    private final String sharedInformation;

    private EcdhDerivationAttributes(BuilderImpl builder) {
        this.certificateAuthorityPublicKeyIdentifier = builder.certificateAuthorityPublicKeyIdentifier;
        this.publicKeyCertificate = builder.publicKeyCertificate;
        this.keyAlgorithm = builder.keyAlgorithm;
        this.keyDerivationFunction = builder.keyDerivationFunction;
        this.keyDerivationHashAlgorithm = builder.keyDerivationHashAlgorithm;
        this.sharedInformation = builder.sharedInformation;
    }

    public final String certificateAuthorityPublicKeyIdentifier() {
        return this.certificateAuthorityPublicKeyIdentifier;
    }

    public final String publicKeyCertificate() {
        return this.publicKeyCertificate;
    }

    public final SymmetricKeyAlgorithm keyAlgorithm() {
        return SymmetricKeyAlgorithm.fromValue(this.keyAlgorithm);
    }

    public final String keyAlgorithmAsString() {
        return this.keyAlgorithm;
    }

    public final KeyDerivationFunction keyDerivationFunction() {
        return KeyDerivationFunction.fromValue(this.keyDerivationFunction);
    }

    public final String keyDerivationFunctionAsString() {
        return this.keyDerivationFunction;
    }

    public final KeyDerivationHashAlgorithm keyDerivationHashAlgorithm() {
        return KeyDerivationHashAlgorithm.fromValue(this.keyDerivationHashAlgorithm);
    }

    public final String keyDerivationHashAlgorithmAsString() {
        return this.keyDerivationHashAlgorithm;
    }

    public final String sharedInformation() {
        return this.sharedInformation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAuthorityPublicKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicKeyCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyDerivationFunctionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyDerivationHashAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharedInformation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcdhDerivationAttributes)) {
            return false;
        }
        EcdhDerivationAttributes other = (EcdhDerivationAttributes)obj;
        return Objects.equals(this.certificateAuthorityPublicKeyIdentifier(), other.certificateAuthorityPublicKeyIdentifier()) && Objects.equals(this.publicKeyCertificate(), other.publicKeyCertificate()) && Objects.equals(this.keyAlgorithmAsString(), other.keyAlgorithmAsString()) && Objects.equals(this.keyDerivationFunctionAsString(), other.keyDerivationFunctionAsString()) && Objects.equals(this.keyDerivationHashAlgorithmAsString(), other.keyDerivationHashAlgorithmAsString()) && Objects.equals(this.sharedInformation(), other.sharedInformation());
    }

    public final String toString() {
        return ToString.builder((String)"EcdhDerivationAttributes").add("CertificateAuthorityPublicKeyIdentifier", (Object)this.certificateAuthorityPublicKeyIdentifier()).add("PublicKeyCertificate", (Object)this.publicKeyCertificate()).add("KeyAlgorithm", (Object)this.keyAlgorithmAsString()).add("KeyDerivationFunction", (Object)this.keyDerivationFunctionAsString()).add("KeyDerivationHashAlgorithm", (Object)this.keyDerivationHashAlgorithmAsString()).add("SharedInformation", (Object)this.sharedInformation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateAuthorityPublicKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthorityPublicKeyIdentifier()));
            }
            case "PublicKeyCertificate": {
                return Optional.ofNullable(clazz.cast(this.publicKeyCertificate()));
            }
            case "KeyAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.keyAlgorithmAsString()));
            }
            case "KeyDerivationFunction": {
                return Optional.ofNullable(clazz.cast(this.keyDerivationFunctionAsString()));
            }
            case "KeyDerivationHashAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.keyDerivationHashAlgorithmAsString()));
            }
            case "SharedInformation": {
                return Optional.ofNullable(clazz.cast(this.sharedInformation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("CertificateAuthorityPublicKeyIdentifier", CERTIFICATE_AUTHORITY_PUBLIC_KEY_IDENTIFIER_FIELD);
        map.put("PublicKeyCertificate", PUBLIC_KEY_CERTIFICATE_FIELD);
        map.put("KeyAlgorithm", KEY_ALGORITHM_FIELD);
        map.put("KeyDerivationFunction", KEY_DERIVATION_FUNCTION_FIELD);
        map.put("KeyDerivationHashAlgorithm", KEY_DERIVATION_HASH_ALGORITHM_FIELD);
        map.put("SharedInformation", SHARED_INFORMATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EcdhDerivationAttributes, T> g) {
        return obj -> g.apply((EcdhDerivationAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateAuthorityPublicKeyIdentifier;
        private String publicKeyCertificate;
        private String keyAlgorithm;
        private String keyDerivationFunction;
        private String keyDerivationHashAlgorithm;
        private String sharedInformation;

        private BuilderImpl() {
        }

        private BuilderImpl(EcdhDerivationAttributes model) {
            this.certificateAuthorityPublicKeyIdentifier(model.certificateAuthorityPublicKeyIdentifier);
            this.publicKeyCertificate(model.publicKeyCertificate);
            this.keyAlgorithm(model.keyAlgorithm);
            this.keyDerivationFunction(model.keyDerivationFunction);
            this.keyDerivationHashAlgorithm(model.keyDerivationHashAlgorithm);
            this.sharedInformation(model.sharedInformation);
        }

        public final String getCertificateAuthorityPublicKeyIdentifier() {
            return this.certificateAuthorityPublicKeyIdentifier;
        }

        public final void setCertificateAuthorityPublicKeyIdentifier(String certificateAuthorityPublicKeyIdentifier) {
            this.certificateAuthorityPublicKeyIdentifier = certificateAuthorityPublicKeyIdentifier;
        }

        @Override
        public final Builder certificateAuthorityPublicKeyIdentifier(String certificateAuthorityPublicKeyIdentifier) {
            this.certificateAuthorityPublicKeyIdentifier = certificateAuthorityPublicKeyIdentifier;
            return this;
        }

        public final String getPublicKeyCertificate() {
            return this.publicKeyCertificate;
        }

        public final void setPublicKeyCertificate(String publicKeyCertificate) {
            this.publicKeyCertificate = publicKeyCertificate;
        }

        @Override
        public final Builder publicKeyCertificate(String publicKeyCertificate) {
            this.publicKeyCertificate = publicKeyCertificate;
            return this;
        }

        public final String getKeyAlgorithm() {
            return this.keyAlgorithm;
        }

        public final void setKeyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
        }

        @Override
        public final Builder keyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            return this;
        }

        @Override
        public final Builder keyAlgorithm(SymmetricKeyAlgorithm keyAlgorithm) {
            this.keyAlgorithm(keyAlgorithm == null ? null : keyAlgorithm.toString());
            return this;
        }

        public final String getKeyDerivationFunction() {
            return this.keyDerivationFunction;
        }

        public final void setKeyDerivationFunction(String keyDerivationFunction) {
            this.keyDerivationFunction = keyDerivationFunction;
        }

        @Override
        public final Builder keyDerivationFunction(String keyDerivationFunction) {
            this.keyDerivationFunction = keyDerivationFunction;
            return this;
        }

        @Override
        public final Builder keyDerivationFunction(KeyDerivationFunction keyDerivationFunction) {
            this.keyDerivationFunction(keyDerivationFunction == null ? null : keyDerivationFunction.toString());
            return this;
        }

        public final String getKeyDerivationHashAlgorithm() {
            return this.keyDerivationHashAlgorithm;
        }

        public final void setKeyDerivationHashAlgorithm(String keyDerivationHashAlgorithm) {
            this.keyDerivationHashAlgorithm = keyDerivationHashAlgorithm;
        }

        @Override
        public final Builder keyDerivationHashAlgorithm(String keyDerivationHashAlgorithm) {
            this.keyDerivationHashAlgorithm = keyDerivationHashAlgorithm;
            return this;
        }

        @Override
        public final Builder keyDerivationHashAlgorithm(KeyDerivationHashAlgorithm keyDerivationHashAlgorithm) {
            this.keyDerivationHashAlgorithm(keyDerivationHashAlgorithm == null ? null : keyDerivationHashAlgorithm.toString());
            return this;
        }

        public final String getSharedInformation() {
            return this.sharedInformation;
        }

        public final void setSharedInformation(String sharedInformation) {
            this.sharedInformation = sharedInformation;
        }

        @Override
        public final Builder sharedInformation(String sharedInformation) {
            this.sharedInformation = sharedInformation;
            return this;
        }

        public EcdhDerivationAttributes build() {
            return new EcdhDerivationAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EcdhDerivationAttributes> {
        public Builder certificateAuthorityPublicKeyIdentifier(String var1);

        public Builder publicKeyCertificate(String var1);

        public Builder keyAlgorithm(String var1);

        public Builder keyAlgorithm(SymmetricKeyAlgorithm var1);

        public Builder keyDerivationFunction(String var1);

        public Builder keyDerivationFunction(KeyDerivationFunction var1);

        public Builder keyDerivationHashAlgorithm(String var1);

        public Builder keyDerivationHashAlgorithm(KeyDerivationHashAlgorithm var1);

        public Builder sharedInformation(String var1);
    }
}

