/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MacAlgorithm {
    ISO9797_ALGORITHM1("ISO9797_ALGORITHM1"),
    ISO9797_ALGORITHM3("ISO9797_ALGORITHM3"),
    CMAC("CMAC"),
    HMAC("HMAC"),
    HMAC_SHA224("HMAC_SHA224"),
    HMAC_SHA256("HMAC_SHA256"),
    HMAC_SHA384("HMAC_SHA384"),
    HMAC_SHA512("HMAC_SHA512"),
    AS2805_4_1("AS2805_4_1"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MacAlgorithm> VALUE_MAP;
    private final String value;

    private MacAlgorithm(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MacAlgorithm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MacAlgorithm> knownValues() {
        EnumSet<MacAlgorithm> knownValues = EnumSet.allOf(MacAlgorithm.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MacAlgorithm.class, MacAlgorithm::toString);
    }
}

