/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ApplicationPolicyType {
    ALL_APPLICATION_POLICIES("ALL_APPLICATION_POLICIES"),
    ANY_PURPOSE("ANY_PURPOSE"),
    ATTESTATION_IDENTITY_KEY_CERTIFICATE("ATTESTATION_IDENTITY_KEY_CERTIFICATE"),
    CERTIFICATE_REQUEST_AGENT("CERTIFICATE_REQUEST_AGENT"),
    CLIENT_AUTHENTICATION("CLIENT_AUTHENTICATION"),
    CODE_SIGNING("CODE_SIGNING"),
    CTL_USAGE("CTL_USAGE"),
    DIGITAL_RIGHTS("DIGITAL_RIGHTS"),
    DIRECTORY_SERVICE_EMAIL_REPLICATION("DIRECTORY_SERVICE_EMAIL_REPLICATION"),
    DISALLOWED_LIST("DISALLOWED_LIST"),
    DNS_SERVER_TRUST("DNS_SERVER_TRUST"),
    DOCUMENT_ENCRYPTION("DOCUMENT_ENCRYPTION"),
    DOCUMENT_SIGNING("DOCUMENT_SIGNING"),
    DYNAMIC_CODE_GENERATOR("DYNAMIC_CODE_GENERATOR"),
    EARLY_LAUNCH_ANTIMALWARE_DRIVER("EARLY_LAUNCH_ANTIMALWARE_DRIVER"),
    EMBEDDED_WINDOWS_SYSTEM_COMPONENT_VERIFICATION("EMBEDDED_WINDOWS_SYSTEM_COMPONENT_VERIFICATION"),
    ENCLAVE("ENCLAVE"),
    ENCRYPTING_FILE_SYSTEM("ENCRYPTING_FILE_SYSTEM"),
    ENDORSEMENT_KEY_CERTIFICATE("ENDORSEMENT_KEY_CERTIFICATE"),
    FILE_RECOVERY("FILE_RECOVERY"),
    HAL_EXTENSION("HAL_EXTENSION"),
    IP_SECURITY_END_SYSTEM("IP_SECURITY_END_SYSTEM"),
    IP_SECURITY_IKE_INTERMEDIATE("IP_SECURITY_IKE_INTERMEDIATE"),
    IP_SECURITY_TUNNEL_TERMINATION("IP_SECURITY_TUNNEL_TERMINATION"),
    IP_SECURITY_USER("IP_SECURITY_USER"),
    ISOLATED_USER_MODE("ISOLATED_USER_MODE"),
    KDC_AUTHENTICATION("KDC_AUTHENTICATION"),
    KERNEL_MODE_CODE_SIGNING("KERNEL_MODE_CODE_SIGNING"),
    KEY_PACK_LICENSES("KEY_PACK_LICENSES"),
    KEY_RECOVERY("KEY_RECOVERY"),
    KEY_RECOVERY_AGENT("KEY_RECOVERY_AGENT"),
    LICENSE_SERVER_VERIFICATION("LICENSE_SERVER_VERIFICATION"),
    LIFETIME_SIGNING("LIFETIME_SIGNING"),
    MICROSOFT_PUBLISHER("MICROSOFT_PUBLISHER"),
    MICROSOFT_TIME_STAMPING("MICROSOFT_TIME_STAMPING"),
    MICROSOFT_TRUST_LIST_SIGNING("MICROSOFT_TRUST_LIST_SIGNING"),
    OCSP_SIGNING("OCSP_SIGNING"),
    OEM_WINDOWS_SYSTEM_COMPONENT_VERIFICATION("OEM_WINDOWS_SYSTEM_COMPONENT_VERIFICATION"),
    PLATFORM_CERTIFICATE("PLATFORM_CERTIFICATE"),
    PREVIEW_BUILD_SIGNING("PREVIEW_BUILD_SIGNING"),
    PRIVATE_KEY_ARCHIVAL("PRIVATE_KEY_ARCHIVAL"),
    PROTECTED_PROCESS_LIGHT_VERIFICATION("PROTECTED_PROCESS_LIGHT_VERIFICATION"),
    PROTECTED_PROCESS_VERIFICATION("PROTECTED_PROCESS_VERIFICATION"),
    QUALIFIED_SUBORDINATION("QUALIFIED_SUBORDINATION"),
    REVOKED_LIST_SIGNER("REVOKED_LIST_SIGNER"),
    ROOT_PROGRAM_AUTO_UPDATE_CA_REVOCATION("ROOT_PROGRAM_AUTO_UPDATE_CA_REVOCATION"),
    ROOT_PROGRAM_AUTO_UPDATE_END_REVOCATION("ROOT_PROGRAM_AUTO_UPDATE_END_REVOCATION"),
    ROOT_PROGRAM_NO_OSCP_FAILOVER_TO_CRL("ROOT_PROGRAM_NO_OSCP_FAILOVER_TO_CRL"),
    ROOT_LIST_SIGNER("ROOT_LIST_SIGNER"),
    SECURE_EMAIL("SECURE_EMAIL"),
    SERVER_AUTHENTICATION("SERVER_AUTHENTICATION"),
    SMART_CARD_LOGIN("SMART_CARD_LOGIN"),
    SPC_ENCRYPTED_DIGEST_RETRY_COUNT("SPC_ENCRYPTED_DIGEST_RETRY_COUNT"),
    SPC_RELAXED_PE_MARKER_CHECK("SPC_RELAXED_PE_MARKER_CHECK"),
    TIME_STAMPING("TIME_STAMPING"),
    WINDOWS_HARDWARE_DRIVER_ATTESTED_VERIFICATION("WINDOWS_HARDWARE_DRIVER_ATTESTED_VERIFICATION"),
    WINDOWS_HARDWARE_DRIVER_EXTENDED_VERIFICATION("WINDOWS_HARDWARE_DRIVER_EXTENDED_VERIFICATION"),
    WINDOWS_HARDWARE_DRIVER_VERIFICATION("WINDOWS_HARDWARE_DRIVER_VERIFICATION"),
    WINDOWS_HELLO_RECOVERY_KEY_ENCRYPTION("WINDOWS_HELLO_RECOVERY_KEY_ENCRYPTION"),
    WINDOWS_KITS_COMPONENT("WINDOWS_KITS_COMPONENT"),
    WINDOWS_RT_VERIFICATION("WINDOWS_RT_VERIFICATION"),
    WINDOWS_SOFTWARE_EXTENSION_VERIFICATION("WINDOWS_SOFTWARE_EXTENSION_VERIFICATION"),
    WINDOWS_STORE("WINDOWS_STORE"),
    WINDOWS_SYSTEM_COMPONENT_VERIFICATION("WINDOWS_SYSTEM_COMPONENT_VERIFICATION"),
    WINDOWS_TCB_COMPONENT("WINDOWS_TCB_COMPONENT"),
    WINDOWS_THIRD_PARTY_APPLICATION_COMPONENT("WINDOWS_THIRD_PARTY_APPLICATION_COMPONENT"),
    WINDOWS_UPDATE("WINDOWS_UPDATE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ApplicationPolicyType> VALUE_MAP;
    private final String value;

    private ApplicationPolicyType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ApplicationPolicyType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ApplicationPolicyType> knownValues() {
        EnumSet<ApplicationPolicyType> knownValues = EnumSet.allOf(ApplicationPolicyType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ApplicationPolicyType.class, ApplicationPolicyType::toString);
    }
}

