/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.personalize.model.HyperParametersCopier;
import software.amazon.awssdk.services.personalize.model.RankingInfluenceCopier;
import software.amazon.awssdk.services.personalize.model.RankingInfluenceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchInferenceJobConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchInferenceJobConfig> {
    private static final SdkField<Map<String, String>> ITEM_EXPLORATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("itemExplorationConfig").getter(BatchInferenceJobConfig.getter(BatchInferenceJobConfig::itemExplorationConfig)).setter(BatchInferenceJobConfig.setter(Builder::itemExplorationConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemExplorationConfig").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Double>> RANKING_INFLUENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("rankingInfluence").getter(BatchInferenceJobConfig.getter(BatchInferenceJobConfig::rankingInfluenceAsStrings)).setter(BatchInferenceJobConfig.setter(Builder::rankingInfluenceWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rankingInfluence").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_EXPLORATION_CONFIG_FIELD, RANKING_INFLUENCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchInferenceJobConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, String> itemExplorationConfig;
    private final Map<String, Double> rankingInfluence;

    private BatchInferenceJobConfig(BuilderImpl builder) {
        this.itemExplorationConfig = builder.itemExplorationConfig;
        this.rankingInfluence = builder.rankingInfluence;
    }

    public final boolean hasItemExplorationConfig() {
        return this.itemExplorationConfig != null && !(this.itemExplorationConfig instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> itemExplorationConfig() {
        return this.itemExplorationConfig;
    }

    public final Map<RankingInfluenceType, Double> rankingInfluence() {
        return RankingInfluenceCopier.copyStringToEnum(this.rankingInfluence);
    }

    public final boolean hasRankingInfluence() {
        return this.rankingInfluence != null && !(this.rankingInfluence instanceof SdkAutoConstructMap);
    }

    public final Map<String, Double> rankingInfluenceAsStrings() {
        return this.rankingInfluence;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItemExplorationConfig() ? this.itemExplorationConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRankingInfluence() ? this.rankingInfluenceAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchInferenceJobConfig)) {
            return false;
        }
        BatchInferenceJobConfig other = (BatchInferenceJobConfig)obj;
        return this.hasItemExplorationConfig() == other.hasItemExplorationConfig() && Objects.equals(this.itemExplorationConfig(), other.itemExplorationConfig()) && this.hasRankingInfluence() == other.hasRankingInfluence() && Objects.equals(this.rankingInfluenceAsStrings(), other.rankingInfluenceAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"BatchInferenceJobConfig").add("ItemExplorationConfig", this.hasItemExplorationConfig() ? this.itemExplorationConfig() : null).add("RankingInfluence", this.hasRankingInfluence() ? this.rankingInfluenceAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "itemExplorationConfig": {
                return Optional.ofNullable(clazz.cast(this.itemExplorationConfig()));
            }
            case "rankingInfluence": {
                return Optional.ofNullable(clazz.cast(this.rankingInfluenceAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("itemExplorationConfig", ITEM_EXPLORATION_CONFIG_FIELD);
        map.put("rankingInfluence", RANKING_INFLUENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchInferenceJobConfig, T> g) {
        return obj -> g.apply((BatchInferenceJobConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> itemExplorationConfig = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, Double> rankingInfluence = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchInferenceJobConfig model) {
            this.itemExplorationConfig(model.itemExplorationConfig);
            this.rankingInfluenceWithStrings(model.rankingInfluence);
        }

        public final Map<String, String> getItemExplorationConfig() {
            if (this.itemExplorationConfig instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.itemExplorationConfig;
        }

        public final void setItemExplorationConfig(Map<String, String> itemExplorationConfig) {
            this.itemExplorationConfig = HyperParametersCopier.copy(itemExplorationConfig);
        }

        @Override
        public final Builder itemExplorationConfig(Map<String, String> itemExplorationConfig) {
            this.itemExplorationConfig = HyperParametersCopier.copy(itemExplorationConfig);
            return this;
        }

        public final Map<String, Double> getRankingInfluence() {
            if (this.rankingInfluence instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.rankingInfluence;
        }

        public final void setRankingInfluence(Map<String, Double> rankingInfluence) {
            this.rankingInfluence = RankingInfluenceCopier.copy(rankingInfluence);
        }

        @Override
        public final Builder rankingInfluenceWithStrings(Map<String, Double> rankingInfluence) {
            this.rankingInfluence = RankingInfluenceCopier.copy(rankingInfluence);
            return this;
        }

        @Override
        public final Builder rankingInfluence(Map<RankingInfluenceType, Double> rankingInfluence) {
            this.rankingInfluence = RankingInfluenceCopier.copyEnumToString(rankingInfluence);
            return this;
        }

        public BatchInferenceJobConfig build() {
            return new BatchInferenceJobConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchInferenceJobConfig> {
        public Builder itemExplorationConfig(Map<String, String> var1);

        public Builder rankingInfluenceWithStrings(Map<String, Double> var1);

        public Builder rankingInfluence(Map<RankingInfluenceType, Double> var1);
    }
}

