/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RankingInfluenceType {
    POPULARITY("POPULARITY"),
    FRESHNESS("FRESHNESS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RankingInfluenceType> VALUE_MAP;
    private final String value;

    private RankingInfluenceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RankingInfluenceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RankingInfluenceType> knownValues() {
        EnumSet<RankingInfluenceType> knownValues = EnumSet.allOf(RankingInfluenceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RankingInfluenceType.class, RankingInfluenceType::toString);
    }
}

