/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pi.model.DescriptiveMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PerformanceInsightsMetric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PerformanceInsightsMetric> {
    private static final SdkField<String> METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Metric").getter(PerformanceInsightsMetric.getter(PerformanceInsightsMetric::metric)).setter(PerformanceInsightsMetric.setter(Builder::metric)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metric").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(PerformanceInsightsMetric.getter(PerformanceInsightsMetric::displayName)).setter(PerformanceInsightsMetric.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<Map<String, String>> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Dimensions").getter(PerformanceInsightsMetric.getter(PerformanceInsightsMetric::dimensions)).setter(PerformanceInsightsMetric.setter(Builder::dimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Filter").getter(PerformanceInsightsMetric.getter(PerformanceInsightsMetric::filter)).setter(PerformanceInsightsMetric.setter(Builder::filter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Double> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Value").getter(PerformanceInsightsMetric.getter(PerformanceInsightsMetric::value)).setter(PerformanceInsightsMetric.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_FIELD, DISPLAY_NAME_FIELD, DIMENSIONS_FIELD, FILTER_FIELD, VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PerformanceInsightsMetric.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String metric;
    private final String displayName;
    private final Map<String, String> dimensions;
    private final Map<String, String> filter;
    private final Double value;

    private PerformanceInsightsMetric(BuilderImpl builder) {
        this.metric = builder.metric;
        this.displayName = builder.displayName;
        this.dimensions = builder.dimensions;
        this.filter = builder.filter;
        this.value = builder.value;
    }

    public final String metric() {
        return this.metric;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final boolean hasDimensions() {
        return this.dimensions != null && !(this.dimensions instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> dimensions() {
        return this.dimensions;
    }

    public final boolean hasFilter() {
        return this.filter != null && !(this.filter instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> filter() {
        return this.filter;
    }

    public final Double value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metric());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensions() ? this.dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilter() ? this.filter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PerformanceInsightsMetric)) {
            return false;
        }
        PerformanceInsightsMetric other = (PerformanceInsightsMetric)obj;
        return Objects.equals(this.metric(), other.metric()) && Objects.equals(this.displayName(), other.displayName()) && this.hasDimensions() == other.hasDimensions() && Objects.equals(this.dimensions(), other.dimensions()) && this.hasFilter() == other.hasFilter() && Objects.equals(this.filter(), other.filter()) && Objects.equals(this.value(), other.value());
    }

    public final String toString() {
        return ToString.builder((String)"PerformanceInsightsMetric").add("Metric", (Object)this.metric()).add("DisplayName", (Object)this.displayName()).add("Dimensions", this.hasDimensions() ? this.dimensions() : null).add("Filter", this.hasFilter() ? this.filter() : null).add("Value", (Object)this.value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Metric": {
                return Optional.ofNullable(clazz.cast(this.metric()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Metric", METRIC_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("Dimensions", DIMENSIONS_FIELD);
        map.put("Filter", FILTER_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PerformanceInsightsMetric, T> g) {
        return obj -> g.apply((PerformanceInsightsMetric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metric;
        private String displayName;
        private Map<String, String> dimensions = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> filter = DefaultSdkAutoConstructMap.getInstance();
        private Double value;

        private BuilderImpl() {
        }

        private BuilderImpl(PerformanceInsightsMetric model) {
            this.metric(model.metric);
            this.displayName(model.displayName);
            this.dimensions(model.dimensions);
            this.filter(model.filter);
            this.value(model.value);
        }

        public final String getMetric() {
            return this.metric;
        }

        public final void setMetric(String metric) {
            this.metric = metric;
        }

        @Override
        public final Builder metric(String metric) {
            this.metric = metric;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Map<String, String> getDimensions() {
            if (this.dimensions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.dimensions;
        }

        public final void setDimensions(Map<String, String> dimensions) {
            this.dimensions = DescriptiveMapCopier.copy(dimensions);
        }

        @Override
        public final Builder dimensions(Map<String, String> dimensions) {
            this.dimensions = DescriptiveMapCopier.copy(dimensions);
            return this;
        }

        public final Map<String, String> getFilter() {
            if (this.filter instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.filter;
        }

        public final void setFilter(Map<String, String> filter) {
            this.filter = DescriptiveMapCopier.copy(filter);
        }

        @Override
        public final Builder filter(Map<String, String> filter) {
            this.filter = DescriptiveMapCopier.copy(filter);
            return this;
        }

        public final Double getValue() {
            return this.value;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        public PerformanceInsightsMetric build() {
            return new PerformanceInsightsMetric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PerformanceInsightsMetric> {
        public Builder metric(String var1);

        public Builder displayName(String var1);

        public Builder dimensions(Map<String, String> var1);

        public Builder filter(Map<String, String> var1);

        public Builder value(Double var1);
    }
}

