/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pi.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pi.PiAsyncClient;
import software.amazon.awssdk.services.pi.internal.UserAgentUtils;
import software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsRequest;
import software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsResponse;

public class ListAvailableResourceMetricsPublisher
implements SdkPublisher<ListAvailableResourceMetricsResponse> {
    private final PiAsyncClient client;
    private final ListAvailableResourceMetricsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAvailableResourceMetricsPublisher(PiAsyncClient client, ListAvailableResourceMetricsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAvailableResourceMetricsPublisher(PiAsyncClient client, ListAvailableResourceMetricsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAvailableResourceMetricsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAvailableResourceMetricsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAvailableResourceMetricsResponseFetcher
    implements AsyncPageFetcher<ListAvailableResourceMetricsResponse> {
        private ListAvailableResourceMetricsResponseFetcher() {
        }

        public boolean hasNextPage(ListAvailableResourceMetricsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAvailableResourceMetricsResponse> nextPage(ListAvailableResourceMetricsResponse previousPage) {
            if (previousPage == null) {
                return ListAvailableResourceMetricsPublisher.this.client.listAvailableResourceMetrics(ListAvailableResourceMetricsPublisher.this.firstRequest);
            }
            return ListAvailableResourceMetricsPublisher.this.client.listAvailableResourceMetrics((ListAvailableResourceMetricsRequest)((Object)ListAvailableResourceMetricsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

