/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VoiceTemplateRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VoiceTemplateRequest> {
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Body").getter(VoiceTemplateRequest.getter(VoiceTemplateRequest::body)).setter(VoiceTemplateRequest.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()}).build();
    private static final SdkField<String> DEFAULT_SUBSTITUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultSubstitutions").getter(VoiceTemplateRequest.getter(VoiceTemplateRequest::defaultSubstitutions)).setter(VoiceTemplateRequest.setter(Builder::defaultSubstitutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSubstitutions").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(VoiceTemplateRequest.getter(VoiceTemplateRequest::languageCode)).setter(VoiceTemplateRequest.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(VoiceTemplateRequest.getter(VoiceTemplateRequest::tags)).setter(VoiceTemplateRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TEMPLATE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateDescription").getter(VoiceTemplateRequest.getter(VoiceTemplateRequest::templateDescription)).setter(VoiceTemplateRequest.setter(Builder::templateDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateDescription").build()}).build();
    private static final SdkField<String> VOICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VoiceId").getter(VoiceTemplateRequest.getter(VoiceTemplateRequest::voiceId)).setter(VoiceTemplateRequest.setter(Builder::voiceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD, DEFAULT_SUBSTITUTIONS_FIELD, LANGUAGE_CODE_FIELD, TAGS_FIELD, TEMPLATE_DESCRIPTION_FIELD, VOICE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String body;
    private final String defaultSubstitutions;
    private final String languageCode;
    private final Map<String, String> tags;
    private final String templateDescription;
    private final String voiceId;

    private VoiceTemplateRequest(BuilderImpl builder) {
        this.body = builder.body;
        this.defaultSubstitutions = builder.defaultSubstitutions;
        this.languageCode = builder.languageCode;
        this.tags = builder.tags;
        this.templateDescription = builder.templateDescription;
        this.voiceId = builder.voiceId;
    }

    public final String body() {
        return this.body;
    }

    public final String defaultSubstitutions() {
        return this.defaultSubstitutions;
    }

    public final String languageCode() {
        return this.languageCode;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String templateDescription() {
        return this.templateDescription;
    }

    public final String voiceId() {
        return this.voiceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultSubstitutions());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.templateDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VoiceTemplateRequest)) {
            return false;
        }
        VoiceTemplateRequest other = (VoiceTemplateRequest)obj;
        return Objects.equals(this.body(), other.body()) && Objects.equals(this.defaultSubstitutions(), other.defaultSubstitutions()) && Objects.equals(this.languageCode(), other.languageCode()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.templateDescription(), other.templateDescription()) && Objects.equals(this.voiceId(), other.voiceId());
    }

    public final String toString() {
        return ToString.builder((String)"VoiceTemplateRequest").add("Body", (Object)this.body()).add("DefaultSubstitutions", (Object)this.defaultSubstitutions()).add("LanguageCode", (Object)this.languageCode()).add("Tags", this.hasTags() ? this.tags() : null).add("TemplateDescription", (Object)this.templateDescription()).add("VoiceId", (Object)this.voiceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "DefaultSubstitutions": {
                return Optional.ofNullable(clazz.cast(this.defaultSubstitutions()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCode()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TemplateDescription": {
                return Optional.ofNullable(clazz.cast(this.templateDescription()));
            }
            case "VoiceId": {
                return Optional.ofNullable(clazz.cast(this.voiceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VoiceTemplateRequest, T> g) {
        return obj -> g.apply((VoiceTemplateRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String body;
        private String defaultSubstitutions;
        private String languageCode;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String templateDescription;
        private String voiceId;

        private BuilderImpl() {
        }

        private BuilderImpl(VoiceTemplateRequest model) {
            this.body(model.body);
            this.defaultSubstitutions(model.defaultSubstitutions);
            this.languageCode(model.languageCode);
            this.tags(model.tags);
            this.templateDescription(model.templateDescription);
            this.voiceId(model.voiceId);
        }

        public final String getBody() {
            return this.body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final String getDefaultSubstitutions() {
            return this.defaultSubstitutions;
        }

        @Override
        public final Builder defaultSubstitutions(String defaultSubstitutions) {
            this.defaultSubstitutions = defaultSubstitutions;
            return this;
        }

        public final void setDefaultSubstitutions(String defaultSubstitutions) {
            this.defaultSubstitutions = defaultSubstitutions;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
        }

        public final String getTemplateDescription() {
            return this.templateDescription;
        }

        @Override
        public final Builder templateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
            return this;
        }

        public final void setTemplateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
        }

        public final String getVoiceId() {
            return this.voiceId;
        }

        @Override
        public final Builder voiceId(String voiceId) {
            this.voiceId = voiceId;
            return this;
        }

        public final void setVoiceId(String voiceId) {
            this.voiceId = voiceId;
        }

        public VoiceTemplateRequest build() {
            return new VoiceTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VoiceTemplateRequest> {
        public Builder body(String var1);

        public Builder defaultSubstitutions(String var1);

        public Builder languageCode(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder templateDescription(String var1);

        public Builder voiceId(String var1);
    }
}

